/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsApplicationCreationWizardPage;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsResourceCreationWizardPage;

public class JaxrsResourceCreationWizard
extends NewElementWizard
implements INewWizard {
    private IJaxrsMetamodel metamodel;
    private IStructuredSelection selection;
    private JaxrsResourceCreationWizardPage resourcePage;
    private JaxrsApplicationCreationWizardPage applicationPage;

    public JaxrsResourceCreationWizard() {
        this.setDefaultPageImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor("wizard/WebServiceWizBan.png"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        IJavaProject javaProject = this.getJavaProject(selection);
        if (javaProject != null) {
            try {
                this.metamodel = JaxrsMetamodelLocator.get((IJavaProject)javaProject);
            }
            catch (CoreException e) {
                Logger.error("Failed to retrieve JAX-RS metamodel for Java Project '" + javaProject + "'", e);
            }
        }
    }

    private IJavaProject getJavaProject(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IJavaElement) {
            return ((IJavaElement)selectedElement).getJavaProject();
        }
        if (selectedElement instanceof UriPathTemplateCategory) {
            return ((UriPathTemplateCategory)selectedElement).getJavaProject();
        }
        return null;
    }

    public void addPages() {
        this.resourcePage = new JaxrsResourceCreationWizardPage();
        this.addPage((IWizardPage)this.resourcePage);
        this.resourcePage.init(this.selection);
        this.applicationPage = new JaxrsApplicationCreationWizardPage(true);
        this.addPage((IWizardPage)this.applicationPage);
        if (this.metamodel != null && this.metamodel.hasApplication()) {
            this.applicationPage.setApplicationAlreadyExists(true);
        }
        this.applicationPage.init(this.selection);
    }

    public boolean performFinish() {
        boolean resourceCreated = super.performFinish();
        if (resourceCreated) {
            try {
                JavaUI.openInEditor((IJavaElement)this.resourcePage.getCreatedType());
            }
            catch (PartInitException e) {
                Logger.error("Failed to open '" + this.resourcePage.getCreatedType().getFullyQualifiedName() + "'", e);
            }
            catch (JavaModelException e) {
                Logger.error("Failed to open '" + this.resourcePage.getCreatedType().getFullyQualifiedName() + "'", e);
            }
        }
        return resourceCreated;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.resourcePage.createType(monitor);
        if (this.applicationPage != null) {
            this.applicationPage.createType(monitor);
        }
    }

    public IJavaElement getCreatedElement() {
        return this.resourcePage.getCreatedType();
    }
}

