/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.util.Iterator;
import java.util.Stack;
import org.jboss.tools.ws.ui.views.TestEntry;

public class TestHistory {
    private Stack<TestEntry> entries = new Stack();

    public Stack<TestEntry> getEntries() {
        return this.entries;
    }

    public TestEntry findEntryByURL(String urlStr) {
        for (TestEntry entry : this.entries) {
            if (!entry.getUrl().contentEquals(urlStr)) continue;
            return entry;
        }
        return null;
    }

    public void addEntry(TestEntry newEntry) {
        this.entries.push(newEntry);
    }

    public void replaceEntry(TestEntry oldEntry, TestEntry newEntry) {
        boolean found = this.entries.remove(oldEntry);
        if (found) {
            this.addEntry(newEntry);
        }
    }

    public String toString() {
        String result = "TestHistory [entries= \n";
        Iterator entryIter = this.entries.iterator();
        while (entryIter.hasNext()) {
            TestEntry entry = (TestEntry)entryIter.next();
            result = String.valueOf(result) + entry.toString();
            if (!entryIter.hasNext()) continue;
            result = String.valueOf(result) + '\n';
        }
        result = String.valueOf(result) + "]";
        return result;
    }
}

