/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.AngularType;
import tern.angular.modules.AngularElement;
import tern.angular.modules.DirectiveHelper;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;
import tern.server.protocol.outline.IJSNode;
import tern.utils.StringUtils;

public class Directive
extends AngularElement {
    private final String url;
    private final String restrict;
    private final Module module;
    private final Collection<String> tagNames;
    private String description;
    private final DirectiveValue directiveValue;
    private Map<String, DirectiveParameter> parameters;
    private final boolean custom;
    private final AngularType type;

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, IJSNode parent) {
        this(name, type, url, tagNames, restrict, directiveValue, null, null, null, parent);
    }

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, Long start, Long end, String file, IJSNode parent) {
        this(name, type, url, tagNames, restrict, directiveValue, true, start, end, file, parent);
    }

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, boolean custom, IJSNode parent) {
        this(name, type, url, tagNames, restrict, directiveValue, custom, null, null, null, parent);
    }

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, boolean custom, Long start, Long end, String file, IJSNode parent) {
        super(name, AngularType.directive, start, end, file, parent);
        Module module;
        this.type = type;
        this.url = url;
        this.restrict = StringUtils.isEmpty(restrict) ? Restriction.A.name() : restrict;
        this.directiveValue = directiveValue;
        this.module = module = (Module)parent;
        this.tagNames = tagNames;
        if (module != null) {
            module.addDirective(this);
        }
        this.custom = custom;
    }

    public Collection<String> getTagNames() {
        return this.tagNames;
    }

    public List<String> getDirectiveNames() {
        return DirectiveHelper.getDirectiveNames(this.getName());
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getURL() {
        return this.url;
    }

    public DirectiveValue getDirectiveValue() {
        return this.directiveValue;
    }

    public Collection<DirectiveParameter> getParameters() {
        if (this.parameters != null) {
            return this.parameters.values();
        }
        return Collections.emptyList();
    }

    public Collection<String> getParameterNames() {
        if (this.parameters != null) {
            return this.parameters.keySet();
        }
        return Collections.emptyList();
    }

    public void addParameter(DirectiveParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, DirectiveParameter>();
        }
        this.parameters.put(parameter.getName(), parameter);
    }

    public boolean hasParameters() {
        if (this.parameters != null) {
            return !this.parameters.isEmpty();
        }
        return false;
    }

    public DirectiveParameter getParameter(String name) {
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        return null;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public boolean isMatch(Restriction restriction) {
        if (restriction == null) {
            return true;
        }
        return restriction.isMatch(this.restrict);
    }

    public String getRestrict() {
        return this.restrict;
    }

    public AngularType getDirectiveType() {
        return this.type;
    }
}

