/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import tern.TernException;
import tern.server.IResponseHandler;
import tern.server.TernExceptionFactory;

public class DefaultResponseHandler
implements IResponseHandler {
    private String error = null;
    private Object data;
    private boolean dataAsJsonString;
    private Throwable t;
    private String json;

    public DefaultResponseHandler(boolean dataAsJsonString) {
        this.dataAsJsonString = dataAsJsonString;
    }

    @Override
    public void onError(String error, Throwable t) {
        this.error = error;
        this.t = t;
        if (t == null) {
            if (this.error != null) {
                this.t = TernExceptionFactory.create(error);
            }
        } else if (this.error == null) {
            this.error = t.getMessage();
        }
    }

    @Override
    public void onSuccess(Object data, String json) {
        this.data = data;
        this.json = json;
    }

    public Object getData() throws TernException {
        if (this.error != null || this.t != null) {
            if (this.t instanceof TernException) {
                throw (TernException)this.t;
            }
            throw new TernException(this.error, this.t);
        }
        return this.data;
    }

    public String getJsonString() throws TernException {
        if (this.error != null || this.t != null) {
            throw new TernException(this.error, this.t);
        }
        return this.json;
    }

    @Override
    public boolean isDataAsJsonString() {
        return this.dataAsJsonString;
    }
}

