/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.definition;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.utils.StringUtils;

public class TernDefinitionResultProcessor
implements ITernResultProcessor<ITernDefinitionCollector> {
    private static final String START_PROPERTY = "start";
    private static final String END_PROPERTY = "end";
    private static final String FILE_PROPERTY = "file";
    private static final String ORIGIN_PROPERTY = "origin";
    public static final TernDefinitionResultProcessor INSTANCE = new TernDefinitionResultProcessor();

    @Override
    public void process(TernDoc doc, IJSONObjectHelper jsonObjectHelper, Object jsonObject, ITernDefinitionCollector collector) {
        this.collect(jsonObjectHelper, jsonObject, collector);
    }

    public void collect(IJSONObjectHelper jsonObjectHelper, Object jsonObject, ITernDefinitionCollector collector) {
        Long startCh = jsonObjectHelper.getCh(jsonObject, START_PROPERTY);
        Long endCh = jsonObjectHelper.getCh(jsonObject, END_PROPERTY);
        String file = jsonObjectHelper.getText(jsonObject, FILE_PROPERTY);
        if (StringUtils.isEmpty(file)) {
            file = jsonObjectHelper.getText(jsonObject, ORIGIN_PROPERTY);
        }
        collector.setDefinition(file, startCh, endCh);
    }
}

