/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

public class StringUtils {
    private static final int[] EMPTY_REGIONS = new int[0];
    public static final String UTF_8 = "UTF-8";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String[] EMPTY_ARRAY = new String[0];

    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public static String normalizeSpace(String s) {
        char c;
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 1) {
            return "";
        }
        int st = 0;
        int off = 0;
        char[] val = s.toCharArray();
        int count = s.length();
        boolean parse = true;
        while (parse) {
            c = val[off + st];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            ++st;
        }
        parse = true;
        while (st < len && val[off + len - 1] <= ' ') {
            c = val[off + len - 1];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            --len;
        }
        return st > 0 || len < count ? s.substring(st, len) : s;
    }

    private static boolean isParse(int len, int st, char c) {
        return st < len && (c == ' ' || c == '\r' || c == '\n' || c == '\t');
    }

    public static boolean asBoolean(String value) {
        return StringUtils.asBoolean(value, false);
    }

    public static boolean asBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        if (defaultValue) {
            return !FALSE.equals(value.toLowerCase()) && !NO.equals(value.toLowerCase());
        }
        return TRUE.equals(value.toLowerCase()) || YES.equals(value.toLowerCase());
    }

    /*
     * Unable to fully structure code
     */
    public static final int[] getPatternMatchingRegions(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return null;
        }
        if (pattern == null) {
            return StringUtils.EMPTY_REGIONS;
        }
        iPattern = patternStart;
        iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        questions = 0;
        parts = 0;
        previous = '\u0000';
        i = patternStart;
        while (i < patternEnd) {
            ch = pattern.charAt(i);
            switch (ch) {
                case '?': {
                    ++questions;
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    switch (previous) {
                        case '\u0000': 
                        case '*': 
                        case '?': {
                            ++parts;
                        }
                    }
                }
            }
            previous = ch;
            ++i;
        }
        if (parts == 0) {
            if (questions <= nameEnd - nameStart) {
                return StringUtils.EMPTY_REGIONS;
            }
            return null;
        }
        segments = new int[parts * 2];
        count = 0;
        start = iName;
        patternChar = '\u0000';
        previous = '\u0000';
        if (true) ** GOTO lbl60
        do {
            if (iName == nameEnd) {
                return null;
            }
            if (patternChar == '?') {
                switch (previous) {
                    case '\u0000': 
                    case '?': {
                        break;
                    }
                    default: {
                        segments[count++] = start;
                        segments[count++] = iPattern - start;
                        break;
                    }
                }
            } else {
                if (isCaseSensitive != false ? patternChar != name.charAt(iName) : StringUtils.toLowerCase(patternChar) != StringUtils.toLowerCase(name.charAt(iName))) {
                    return null;
                }
                switch (previous) {
                    case '\u0000': 
                    case '?': {
                        start = iPattern;
                    }
                }
            }
            ++iName;
            ++iPattern;
            previous = patternChar;
lbl60:
            // 2 sources

            if (iPattern >= patternEnd) break;
            v0 = pattern.charAt(iPattern);
            patternChar = v0;
        } while (v0 != '*');
        if (patternChar == '*') {
            if (iPattern > 0 && previous != '?') {
                segments[count++] = start;
                segments[count++] = iName - start;
                start = iName;
            }
        } else {
            if (iName == nameEnd) {
                if (count == parts * 2) {
                    return segments;
                }
                end = patternEnd;
                if (previous == '?') {
                    while (pattern.charAt(--end - 1) == '?') {
                        if (end != start) continue;
                        return new int[]{patternStart, patternEnd - patternStart};
                    }
                }
                return new int[]{start, end - start};
            }
            return null;
        }
        segmentStart = ++iPattern;
        prefixStart = iName;
        previousCount = count;
        previous = patternChar;
        previousSegment = patternChar;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                previous = previousSegment;
                continue;
            }
            patternChar = pattern.charAt(iPattern);
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    if (count < parts * 2) {
                        segments[count++] = start;
                        segments[count++] = iName - start;
                    }
                    return segments;
                }
                switch (previous) {
                    case '*': 
                    case '?': {
                        break;
                    }
                    default: {
                        segments[count++] = start;
                        segments[count++] = iName - start;
                    }
                }
                start = prefixStart = iName;
                previous = patternChar;
                previousSegment = patternChar;
                continue;
            }
            previousCount = count;
            if (patternChar == '?') {
                switch (previous) {
                    case '*': 
                    case '?': {
                        break;
                    }
                    default: {
                        segments[count++] = start;
                        segments[count++] = iName - start;
                        break;
                    }
                }
            } else {
                if (isCaseSensitive) {
                    mismatch = name.charAt(iName) != patternChar;
                } else {
                    v1 = mismatch = StringUtils.toLowerCase(name.charAt(iName)) != StringUtils.toLowerCase(patternChar);
                }
                if (mismatch) {
                    iPattern = segmentStart;
                    iName = ++prefixStart;
                    start = prefixStart;
                    count = previousCount;
                    previous = previousSegment;
                    continue;
                }
                switch (previous) {
                    case '?': {
                        start = iName;
                    }
                }
            }
            ++iName;
            ++iPattern;
            previous = patternChar;
        }
        if (segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern.charAt(iPattern) == '*') {
            if (count < parts * 2) {
                segments[count++] = start;
                segments[count++] = iName - start;
            }
            return segments;
        }
        return null;
    }

    private static char toLowerCase(char c) {
        return Character.toLowerCase(c);
    }
}

