/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.eclipse.ide.internal.core.TernModuleInstall;
import tern.eclipse.ide.internal.core.Trace;

public class TernModuleInstallManager
implements IRegistryChangeListener {
    private static final String EXTENSION_TERN_MODULE_INSTALLS = "ternModuleInstalls";
    private static final TernModuleInstallManager INSTANCE = new TernModuleInstallManager();
    private List<TernModuleInstall> ternModuleInstalls;
    private boolean registryListenerIntialized = false;

    public static TernModuleInstallManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_MODULE_INSTALLS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernModuleInstallDelta(delta);
                ++n2;
            }
        }
    }

    public TernModuleInstall[] getTernModuleInstalls() {
        if (this.ternModuleInstalls == null) {
            this.loadTernModuleInstalls();
        }
        TernModuleInstall[] st = new TernModuleInstall[this.ternModuleInstalls.size()];
        this.ternModuleInstalls.toArray(st);
        return st;
    }

    private synchronized void loadTernModuleInstalls() {
        if (this.ternModuleInstalls != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternModuleInstalls extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_MODULE_INSTALLS);
        ArrayList<TernModuleInstall> list = new ArrayList<TernModuleInstall>(cf.length);
        this.addTernModuleInstalls(cf, list);
        this.addRegistryListenerIfNeeded();
        this.ternModuleInstalls = list;
        Trace.trace((byte)7, "-<- Done loading .ternModuleInstalls extension point -<-");
    }

    private synchronized void addTernModuleInstalls(IConfigurationElement[] cf, List<TernModuleInstall> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add(new TernModuleInstall(ce));
                Trace.trace((byte)7, "  Loaded ternModuleInstall: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load ternModuleInstall: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected void handleTernModuleInstallDelta(IExtensionDelta delta) {
        if (this.ternModuleInstalls == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<TernModuleInstall> list = new ArrayList<TernModuleInstall>(this.ternModuleInstalls);
        if (delta.getKind() == 1) {
            this.addTernModuleInstalls(cf, list);
        } else {
            int size = list.size();
            TernModuleInstall[] st = new TernModuleInstall[size];
            list.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.ternModuleInstalls = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

