/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import tern.TernException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.core.ITernRepositoryManager;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.IDETernRepository;
import tern.eclipse.ide.internal.core.TernModuleInstall;
import tern.eclipse.ide.internal.core.TernModuleInstallManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.StringUtils;
import tern.utils.TernModuleHelper;

public class TernRepositoryManager
implements ITernRepositoryManager,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final TernRepositoryManager INSTANCE = new TernRepositoryManager();
    private static IIDETernRepository DEFAULT_REPOSITORY;
    private final Map<String, IIDETernRepository> repositories = new HashMap<String, IIDETernRepository>();

    public static TernRepositoryManager getManager() {
        return INSTANCE;
    }

    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public Collection<IIDETernRepository> getRepositories() {
        this.loadRepositoriesIfNeeded();
        return this.repositories.values();
    }

    private void loadRepositoriesIfNeeded() {
        if (this.repositories.size() == 0) {
            this.loadRepositories();
        }
    }

    private synchronized void loadRepositories() {
        if (this.repositories.size() > 0) {
            return;
        }
        this.repositories.clear();
        this.loadDefaultRepositories();
        this.loadCustomRepositories();
        this.installExternalModules();
    }

    private void installExternalModules() {
        TernModuleInstall[] modules;
        TernModuleInstall[] ternModuleInstallArray = modules = TernModuleInstallManager.getManager().getTernModuleInstalls();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            TernModuleInstall module = ternModuleInstallArray[n2];
            Collection<IIDETernRepository> reps = this.repositories.values();
            for (IIDETernRepository repository : reps) {
                try {
                    repository.install(module.getSrc());
                }
                catch (Throwable e) {
                    Trace.trace((byte)3, "Cannot install module" + module.getName(), e);
                }
            }
            ++n2;
        }
    }

    private void loadDefaultRepositories() {
        this.addRepository(this.getDefaultRepository(), this.repositories);
    }

    private void loadCustomRepositories() {
        String values = new InstanceScope().getNode(TernCorePlugin.getDefault().getBundle().getSymbolicName()).get("repositories", null);
        if (!StringUtils.isEmpty((String)values)) {
            String[] s = values.split(";");
            String name = null;
            File baseDir = null;
            int i = 0;
            while (i < s.length / 2) {
                name = s[i];
                baseDir = new File(s[i + 1]);
                this.addRepository(this.createRepository(name, baseDir), this.repositories);
                ++i;
            }
        }
    }

    @Override
    public IIDETernRepository createRepository(String name, File baseDir) {
        return this.createRepository(name, baseDir, false);
    }

    private IIDETernRepository createRepository(String name, File baseDir, boolean isDefault) {
        return new IDETernRepository(name, baseDir, isDefault);
    }

    @Override
    public IIDETernRepository getDefaultRepository() {
        if (DEFAULT_REPOSITORY != null) {
            return DEFAULT_REPOSITORY;
        }
        try {
            DEFAULT_REPOSITORY = this.createDefaultRepository();
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Cannot load the default tern repository.", e);
        }
        return DEFAULT_REPOSITORY;
    }

    private synchronized IIDETernRepository createDefaultRepository() throws TernException, IOException {
        if (DEFAULT_REPOSITORY != null) {
            return DEFAULT_REPOSITORY;
        }
        return this.createRepository("default", TernCorePlugin.getTernRepositoryBaseDir(), true);
    }

    private void addRepository(IIDETernRepository repository, Map<String, IIDETernRepository> repositories) {
        if (repository != null) {
            repositories.put(repository.getName(), repository);
        }
    }

    @Override
    public IIDETernRepository getRepository(String name) {
        this.loadRepositoriesIfNeeded();
        return this.repositories.get(name);
    }

    private IIDETernRepository getRepository(IIDETernProject ternProject) {
        return this.getRepository(ternProject != null ? ternProject.getProject() : null);
    }

    @Override
    public IIDETernRepository getRepository(IProject project) {
        IIDETernRepository repository;
        this.loadRepositoriesIfNeeded();
        String name = TernCorePreferencesSupport.getInstance().getUsedTernRepositoryName(project);
        if (!StringUtils.isEmpty((String)name) && (repository = this.getRepository(name)) != null) {
            return repository;
        }
        return this.getDefaultRepository();
    }

    @Override
    public void setRepositories(Collection<IIDETernRepository> repositories) {
        StringBuilder value = new StringBuilder();
        for (IIDETernRepository repository : repositories) {
            if (repository.isDefault()) continue;
            if (value.length() > 0) {
                value.append(";");
            }
            value.append(repository.getName());
            value.append(";");
            value.append(repository.getTernBaseDirAsString());
        }
        new InstanceScope().getNode(TernCorePlugin.getDefault().getBundle().getSymbolicName()).put("repositories", value.toString());
        this.loadRepositories();
    }

    @Override
    public List<ITernModule> getCheckedModules(IIDETernProject ternProject, List<ITernModule> allModules) {
        ArrayList<ITernModule> checkedModules = new ArrayList<ITernModule>();
        JsonValue options = null;
        JsonObject plugins = ternProject.getPlugins();
        for (String name : plugins.names()) {
            options = plugins.get(name);
            ITernModule plugin = this.findTernModule(name.toString(), ternProject);
            this.updateCheckedModule(plugin, options, allModules, checkedModules);
        }
        JsonArray defs = ternProject.getLibs();
        for (JsonValue name : defs) {
            ITernModule def = this.findTernModule(name.asString(), ternProject);
            this.updateCheckedModule(def, null, allModules, checkedModules);
        }
        return checkedModules;
    }

    @Override
    public List<ITernModule> getCheckedModules(String[] moduleNames, List<ITernModule> allModules, List<ITernModule> groupedModules) {
        ArrayList<ITernModule> checkedModules = new ArrayList<ITernModule>();
        String[] stringArray = moduleNames;
        int n = moduleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ITernModule module = this.findTernModule(name, allModules);
            this.updateCheckedModule(module, null, groupedModules, checkedModules);
            ++n2;
        }
        return checkedModules;
    }

    private void updateCheckedModule(ITernModule module, JsonValue options, List<ITernModule> allModules, List<ITernModule> checkedModules) {
        if (module != null) {
            if (!TernModuleHelper.isConfigurableModule((ITernModule)module)) {
                this.addModule(module, checkedModules);
            } else {
                try {
                    this.addModule((ITernModule)TernModuleHelper.findConfigurable((ITernModule)module, (JsonValue)options, allModules), checkedModules);
                }
                catch (TernException e) {
                    Trace.trace((byte)3, "Error while finding configurable module.", e);
                }
            }
        }
    }

    private void addModule(ITernModule module, List<ITernModule> checkedModules) {
        if (!checkedModules.contains(module)) {
            checkedModules.add(module);
        }
    }

    @Override
    public ITernModule findTernModule(String name, IIDETernProject ternProject) {
        IIDETernRepository repository = this.getRepository(ternProject);
        ITernModule m = repository.getModule(name);
        if (m != null) {
            return m;
        }
        if (ternProject != null) {
            List<ITernModule> projectModules = ternProject.getProjectModules();
            return this.findTernModule(name, projectModules);
        }
        return null;
    }

    private ITernModule findTernModule(String name, List<ITernModule> projectModules) {
        if (projectModules != null) {
            for (ITernModule module : projectModules) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
        }
        return null;
    }

    @Override
    public ITernModule[] getTernModules(String moduleNames, IDETernProject ternProject) {
        ITernModule module = null;
        ArrayList<ITernModule> modules = new ArrayList<ITernModule>();
        String[] names = moduleNames.split(",");
        int i = 0;
        while (i < names.length) {
            module = this.findTernModule(names[i], ternProject);
            if (module != null) {
                this.addModule(module, modules);
            }
            ++i;
        }
        return modules.toArray(ITernPlugin.EMPTY_MODULE);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    if (resource != null && resource.getType() == 4) {
                        IProject project = (IProject)resource;
                        this.disconnectProject(project);
                    }
                    break;
                }
                case 1: {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) break;
                    delta.accept((IResourceDeltaVisitor)this);
                }
                default: {
                    break;
                }
            }
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Error while tern repository synchronization", e);
        }
    }

    private void connectProject(IProject project) {
        for (IIDETernRepository repository : this.repositories.values()) {
            if (!project.getLocation().equals((Object)repository.getLocation())) continue;
            ((IDETernRepository)repository).setProject(project);
        }
    }

    private void disconnectProject(IProject project) {
        for (IIDETernRepository repository : this.repositories.values()) {
            if (!project.equals((Object)repository.getProject())) continue;
            ((IDETernRepository)repository).setProject(null);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                IProject project = (IProject)resource;
                if (project.isOpen() && (delta.getKind() == 4 || delta.getKind() == 1) && (delta.getFlags() & 0x4000) != 0) {
                    this.connectProject(project);
                }
                return false;
            }
        }
        return false;
    }
}

