/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import tern.TernException;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebugger;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileConfigException;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileHelper;
import tern.server.nodejs.process.INodejsLaunchConfiguration;
import tern.server.nodejs.process.INodejsProcess;

public abstract class AbstractNodejsCliFileLauncher
implements INodejsLaunchConfiguration {
    private final IFile configFile;
    private final IFile cliFile;
    private final INodejsDebugger debugger;
    private final File nodeInstallPath;
    private final String mode;

    public AbstractNodejsCliFileLauncher(IFile configFile, IFile cliFile, INodejsDebugger debugger, File nodeInstallPath, String mode) {
        this.configFile = configFile;
        this.cliFile = cliFile;
        this.debugger = debugger;
        this.nodeInstallPath = nodeInstallPath;
        this.mode = mode;
    }

    public AbstractNodejsCliFileLauncher(ILaunchConfiguration configuration, String mode) throws CoreException, NodejsCliFileConfigException {
        this(AbstractNodejsCliFileLauncher.getConfigFile(configuration), AbstractNodejsCliFileLauncher.getCliFile(configuration), AbstractNodejsCliFileLauncher.getDebugger(configuration), AbstractNodejsCliFileLauncher.getNodeInstallPath(configuration), mode);
    }

    private static IFile getConfigFile(ILaunchConfiguration configuration) throws NodejsCliFileConfigException, CoreException {
        String param = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        return NodejsCliFileHelper.getConfigFile(param);
    }

    private static IFile getCliFile(ILaunchConfiguration configuration) throws NodejsCliFileConfigException, CoreException {
        String param = configuration.getAttribute("cli_file", null);
        return NodejsCliFileHelper.getCliFile(param);
    }

    private static File getNodeInstallPath(ILaunchConfiguration configuration) throws NodejsCliFileConfigException, CoreException {
        String nodeInstall = configuration.getAttribute("nodeinstall", null);
        String nodePath = configuration.getAttribute("nodeinstall", null);
        return NodejsCliFileHelper.getNodeInstallPath(nodeInstall, nodePath);
    }

    private static INodejsDebugger getDebugger(ILaunchConfiguration configuration) throws CoreException, NodejsCliFileConfigException {
        String debuggerId = configuration.getAttribute("debugger", null);
        return NodejsCliFileHelper.getDebugger(debuggerId);
    }

    public void start() throws TernException {
        INodejsProcess process = this.debugger.createProcess(this.cliFile, this.configFile.getProject().getLocation().toFile(), this.nodeInstallPath);
        process.setLaunchConfiguration((INodejsLaunchConfiguration)this);
        process.start();
    }

    public List<String> createNodeArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.configFile.getLocation().toOSString());
        return args;
    }

    public String getLaunchMode() {
        return this.mode;
    }

    public boolean isSaveLaunch() {
        return false;
    }

    public boolean isWaitOnPort() {
        return false;
    }

    public IFile getConfigFile() {
        return this.configFile;
    }
}

