/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebugger;
import tern.eclipse.ide.server.nodejs.core.debugger.NodejsDebuggersManager;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileConfigException;
import tern.utils.StringUtils;

public class NodejsCliFileHelper {
    private static final String WORKSPACE_LOC = "workspace_loc";

    private NodejsCliFileHelper() {
    }

    public static IFile getConfigFile(String param) throws NodejsCliFileConfigException, CoreException {
        if (StringUtils.isEmpty((String)param)) {
            throw new NodejsCliFileConfigException("Configuration file cannot be empty.");
        }
        IFile configFile = NodejsCliFileHelper.getResource(param);
        if (configFile != null && configFile.exists()) {
            return configFile;
        }
        throw new NodejsCliFileConfigException("Cannot find configuration file");
    }

    public static IFile getCliFile(String param) throws NodejsCliFileConfigException, CoreException {
        if (StringUtils.isEmpty((String)param)) {
            throw new NodejsCliFileConfigException("Client file cannot be empty.");
        }
        IFile configFile = NodejsCliFileHelper.getResource(param);
        if (configFile != null && configFile.exists()) {
            return configFile;
        }
        throw new NodejsCliFileConfigException("Cannot find client file");
    }

    public static File getNodeInstallPath(String nodeInstall, String nodePath) throws NodejsCliFileConfigException, CoreException {
        if (StringUtils.isEmpty((String)nodeInstall)) {
            throw new NodejsCliFileConfigException("Node.js install cannot be empty.");
        }
        INodejsInstall install = NodejsCliFileHelper.getNodejsInstall(nodeInstall);
        if (install != null) {
            if (install.isNative()) {
                if (StringUtils.isEmpty((String)nodePath)) {
                    throw new NodejsCliFileConfigException("Node.js path cannot be empty.");
                }
                File nodeInstallPath = new File(nodePath);
                if (nodeInstallPath.exists()) {
                    return nodeInstallPath;
                }
                throw new NodejsCliFileConfigException("Cannot find node install path " + nodeInstallPath.toString());
            }
            return install.getPath();
        }
        return new File("node");
    }

    private static INodejsInstall getNodejsInstall(String nodeInstall) {
        return TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(nodeInstall);
    }

    public static INodejsDebugger getDebugger(String debuggerId) throws CoreException, NodejsCliFileConfigException {
        if (StringUtils.isEmpty((String)debuggerId)) {
            throw new NodejsCliFileConfigException("Tern debugger cannot be empty.");
        }
        INodejsDebugger debugger = NodejsDebuggersManager.getDebugger(debuggerId);
        if (debugger != null) {
            return debugger;
        }
        throw new NodejsCliFileConfigException("Cannot find tern debugger with id" + debuggerId);
    }

    public static String getWorkspaceLoc(File file) {
        Object[] res = file.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(file.toURI()) : ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
        if (res != null && res.length > 0) {
            return NodejsCliFileHelper.getWorkspaceLoc((IResource)res[0]);
        }
        return file.toString();
    }

    public static String getWorkspaceLoc(IResource file) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(WORKSPACE_LOC, file.getFullPath().toString());
    }

    public static IFile getResource(String path) throws CoreException {
        String location = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        return NodejsCliFileHelper.getFileForLocation(location);
    }

    public static IFile getFileForLocation(String path) {
        if (path == null) {
            return null;
        }
        Path filePath = new Path(path);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)filePath);
        if (file.exists()) {
            return file;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }
}

