/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.utils.ZipUtils;

public class NodejsInstall
implements INodejsInstall {
    private final String id;
    private final String name;
    private File path;

    public NodejsInstall(IConfigurationElement element) throws IOException {
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        String pluginId = element.getNamespaceIdentifier();
        String path = element.getAttribute("path");
        if (path != null && path.length() > 0) {
            File bundleDir = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            IPath stateLocationPath = InternalPlatform.getDefault().getStateLocation(Platform.getBundle((String)pluginId), true);
            if (stateLocationPath != null) {
                String zip;
                File zipFile;
                File baseDir = stateLocationPath.toFile();
                this.path = new File(baseDir, path);
                if (!this.path.exists() && (zipFile = new File(bundleDir, zip = element.getAttribute("zip"))).exists()) {
                    if (zipFile.getName().toLowerCase().endsWith(".zip")) {
                        ZipUtils.extract((File)zipFile, (File)baseDir);
                    }
                    if (this.path.exists()) {
                        this.path.setExecutable(true);
                    }
                }
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getPath() {
        return this.path;
    }

    public void dispose() {
    }

    @Override
    public boolean isNative() {
        return "node-native".equals(this.getId());
    }
}

