/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import tern.eclipse.ide.server.nodejs.core.debugger.INodejsDebugger;
import tern.eclipse.ide.server.nodejs.core.debugger.NodejsDebuggersManager;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIPlugin;
import tern.eclipse.ide.ui.preferences.CheckComboFieldEditor;

public class DebuggerFieldEditor
extends CheckComboFieldEditor {
    private Link wikiLink;
    private boolean isValid = true;

    public DebuggerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, DebuggerFieldEditor.createDebuggers(), "", parent);
    }

    protected void updateComboBoxEnablement(Composite parent, boolean enabled) {
        super.updateComboBoxEnablement(parent, enabled);
        if (this.wikiLink != null) {
            this.wikiLink.setEnabled(enabled);
        }
    }

    protected void refreshValidState() {
        if (this.isCheckboxSelected()) {
            if (this.getSelection() == 0) {
                this.isValid = false;
                this.showErrorMessage(TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_err_not_selected);
                return;
            }
            if ("".equals(this.getValue())) {
                this.isValid = false;
                this.showErrorMessage(TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_err_not_installed);
                return;
            }
        }
        this.isValid = true;
        this.clearErrorMessage();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static String[][] createDebuggers() {
        Collection list = NodejsDebuggersManager.getDebuggers();
        String[][] debuggers = new String[list.size() + 1][2];
        debuggers[0][0] = TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_none;
        debuggers[0][1] = "";
        int j = 0;
        for (INodejsDebugger debugger : list) {
            ++j;
            if (debugger.isInstalled()) {
                debuggers[j][0] = debugger.getName();
                debuggers[j][1] = debugger.getId();
                continue;
            }
            debuggers[j][0] = String.valueOf(debugger.getName()) + TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_not_installed;
            debuggers[j][1] = "";
        }
        return debuggers;
    }

    public Link createWikiLink(Composite parent, int style) {
        this.wikiLink = DebuggerFieldEditor.newWikiLink(parent, style);
        return this.wikiLink;
    }

    public static Link newWikiLink(Composite parent, int style) {
        Link wikiLink = new Link(parent, style);
        wikiLink.setText(TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_wiki_link);
        wikiLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://github.com/angelozerr/tern.java/wiki/Debugging-Tern.js-on-Node.js"));
                }
                catch (Exception e1) {
                    TernNodejsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.server.nodejs.ui", e1.getMessage(), (Throwable)e1));
                }
            }
        });
        return wikiLink;
    }
}

