/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.DebuggerFieldEditor;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.NodeJSConfigEditor;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.preferences.FileComboFieldEditor;
import tern.eclipse.ide.ui.preferences.TernRepositoryFieldEditor;
import tern.utils.StringUtils;

public class TernNodejsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button remoteAccessButton;
    private IntegerFieldEditor remotePortField;
    private Button directAccessButton;
    private IntegerFieldEditor timeoutField;
    private IntegerFieldEditor testNumberField;
    private BooleanFieldEditor persistentField;
    private DebuggerFieldEditor debuggerField;
    private NodeJSConfigEditor nodeJSConfigEditor;
    private IWorkbench workbench;
    private TernRepositoryFieldEditor ternRepositoryField;

    public TernNodejsPreferencesPage() {
        super(1);
        this.setDescription(TernNodejsUIMessages.TernNodejsPreferencesPage_desc);
        this.setImageDescriptor(ImageResource.getImageDescriptor((String)"logo"));
    }

    protected void createFieldEditors() {
        boolean isRemote = this.getPreferenceStore().getBoolean("nodejsRemoteAccess");
        this.createRemoteAccessContent(this.getFieldEditorParent(), isRemote);
        this.createSeparator(this.getFieldEditorParent());
        this.createDirectAccessContent(this.getFieldEditorParent(), !isRemote);
        this.updateEnabled(isRemote);
    }

    private void createRemoteAccessContent(Composite parent, boolean isRemote) {
        this.remoteAccessButton = this.addRadioButton(parent, TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSRemoteAccess, isRemote);
        this.remoteAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernNodejsPreferencesPage.this.updateEnabled(true);
            }
        });
        this.remotePortField = new IntegerFieldEditor("nodejsRemotePort", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSRemotePort, parent);
        this.addField((FieldEditor)this.remotePortField);
    }

    private void createDirectAccessContent(Composite parent, boolean isDirect) {
        this.directAccessButton = this.addRadioButton(parent, TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSDirectAccess, isDirect);
        this.directAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernNodejsPreferencesPage.this.updateEnabled(false);
            }
        });
        this.timeoutField = new IntegerFieldEditor("nodeJSTimeout", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTimeout, parent);
        this.addField((FieldEditor)this.timeoutField);
        this.testNumberField = new IntegerFieldEditor("nodeJSTestNumber", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSTestNumber, parent);
        this.addField((FieldEditor)this.testNumberField);
        this.persistentField = new BooleanFieldEditor("nodeJSPersistent", TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPersistent, parent);
        this.addField((FieldEditor)this.persistentField);
        this.debuggerField = new DebuggerFieldEditor("nodeJSDebugger", TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_label, parent){

            @Override
            protected void updateComboBoxEnablement(Composite parent, boolean enabled) {
                super.updateComboBoxEnablement(parent, enabled);
                TernNodejsPreferencesPage.this.ternRepositoryField.setEnabled(enabled, parent);
            }
        };
        this.addField((FieldEditor)this.debuggerField);
        this.ternRepositoryField = new TernRepositoryFieldEditor("ternRepository", TernNodejsUIMessages.TernNodejsPreferencesPage_ternRepository_label, parent, this.workbench);
        this.addField((FieldEditor)this.ternRepositoryField);
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.ternRepositoryField.getLabelControl(parent).setLayoutData((Object)gd);
        Link debuggerWikiLink = this.debuggerField.createWikiLink(parent, 0);
        gd = new GridData(4, 4, false, false, 5, 1);
        gd.horizontalIndent = 25;
        debuggerWikiLink.setLayoutData((Object)gd);
        this.nodeJSConfigEditor = new NodeJSConfigEditor(parent, "nodeJSInstall", "nodeJSPath");
        ComboFieldEditor nodeJSInstallField = this.nodeJSConfigEditor.getNodeJSInstallField();
        this.addField((FieldEditor)nodeJSInstallField);
        FileComboFieldEditor nativeNodePath = this.nodeJSConfigEditor.getNativeNodePath();
        this.addField((FieldEditor)nativeNodePath);
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        separator.setLayoutData((Object)gd);
    }

    private Button addRadioButton(Composite parent, String label, boolean selected) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setLayoutData((Object)gd);
        button.setSelection(selected);
        return button;
    }

    private void updateEnabled(boolean isRemote) {
        Composite parent = this.getFieldEditorParent();
        this.remotePortField.setEnabled(isRemote, parent);
        this.timeoutField.setEnabled(!isRemote, parent);
        this.testNumberField.setEnabled(!isRemote, parent);
        this.persistentField.setEnabled(!isRemote, parent);
        this.debuggerField.setEnabled(!isRemote, parent);
        this.ternRepositoryField.setEnabled(this.debuggerField.isCheckboxSelected(), parent);
        this.nodeJSConfigEditor.setEnabled(!isRemote, parent);
    }

    protected void initialize() {
        super.initialize();
        boolean isRemote = this.getPreferenceStore().getBoolean("nodejsRemoteAccess");
        this.nodeJSConfigEditor.updateNodePath(this.getNodejsInstall(false), isRemote, this.getFieldEditorParent());
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "tern.eclipse.ide.server.nodejs.core");
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("nodejsRemoteAccess", this.remoteAccessButton.getSelection());
        TernCorePlugin.getTernServerTypeManager().fireServerPreferencesChanged(null);
        return result;
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean isRemote = this.getPreferenceStore().getDefaultBoolean("nodejsRemoteAccess");
        this.nodeJSConfigEditor.updateNodePath(this.getNodejsInstall(true), isRemote, this.getFieldEditorParent());
        this.remoteAccessButton.setSelection(isRemote);
        this.directAccessButton.setSelection(!isRemote);
        this.updateEnabled(isRemote);
    }

    private INodejsInstall getNodejsInstall(boolean defaultValue) {
        String installId;
        INodejsInstall install = null;
        String string = installId = defaultValue ? super.getPreferenceStore().getDefaultString("nodeJSInstall") : super.getPreferenceStore().getString("nodeJSInstall");
        if (!StringUtils.isEmpty((String)installId)) {
            install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(installId);
        }
        return install;
    }
}

