/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.ui.debugger.preferences;

import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.DebuggerFieldEditor;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.NodeJSConfigEditor;
import tern.eclipse.ide.ui.preferences.FileComboFieldEditor;
import tern.eclipse.ide.ui.preferences.WorkspaceFileFieldEditor;
import tern.utils.StringUtils;

public abstract class AbstractNodejsCliFilePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private WorkspaceFileFieldEditor defaultCliFileField;
    private DebuggerFieldEditor debuggerField;
    private NodeJSConfigEditor nodeJSConfigEditor;

    public AbstractNodejsCliFilePreferencesPage(int style) {
        super(style);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.createCliFileContent(parent);
        this.createSeparator(parent);
        this.createDebuggerContent(parent);
        this.createSeparator(parent);
        this.createNodeInstallContent(parent);
    }

    protected void initialize() {
        super.initialize();
        this.nodeJSConfigEditor.updateNodePath(this.getNodejsInstall(false), false, this.getFieldEditorParent());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.nodeJSConfigEditor.updateNodePath(this.getNodejsInstall(true), false, this.getFieldEditorParent());
    }

    protected void createCliFileContent(Composite parent) {
        this.defaultCliFileField = new WorkspaceFileFieldEditor(this.getCliFilePreferenceName(), this.getCliFileLabel(), parent);
        this.addField((FieldEditor)this.defaultCliFileField);
    }

    protected void createDebuggerContent(Composite parent) {
        this.debuggerField = new DebuggerFieldEditor(this.getDebuggerPreferenceName(), this.getDebuggerLabel(), parent);
        this.addField((FieldEditor)this.debuggerField);
        Link debuggerWikiLink = this.debuggerField.createWikiLink(parent, 0);
        GridData gd = new GridData(4, 4, false, false, 5, 1);
        gd.horizontalIndent = 25;
        debuggerWikiLink.setLayoutData((Object)gd);
    }

    protected void createNodeInstallContent(Composite parent) {
        this.nodeJSConfigEditor = new NodeJSConfigEditor(parent, this.getNodeJSInstallPreferenceName(), this.getNodeJSPathPreferenceName());
        ComboFieldEditor nodeJSInstallField = this.nodeJSConfigEditor.getNodeJSInstallField();
        this.addField((FieldEditor)nodeJSInstallField);
        FileComboFieldEditor nativeNodePath = this.nodeJSConfigEditor.getNativeNodePath();
        this.addField((FieldEditor)nativeNodePath);
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        separator.setLayoutData((Object)gd);
    }

    public void init(IWorkbench workbench) {
    }

    private INodejsInstall getNodejsInstall(boolean defaultValue) {
        String installId;
        INodejsInstall install = null;
        String string = installId = defaultValue ? super.getPreferenceStore().getDefaultString(this.getNodeJSInstallPreferenceName()) : super.getPreferenceStore().getString(this.getNodeJSInstallPreferenceName());
        if (!StringUtils.isEmpty((String)installId)) {
            install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(installId);
        }
        return install;
    }

    protected abstract String getCliFilePreferenceName();

    protected abstract String getCliFileLabel();

    protected abstract String getDebuggerPreferenceName();

    protected abstract String getDebuggerLabel();

    protected abstract String getNodeJSInstallPreferenceName();

    protected abstract String getNodeJSPathPreferenceName();
}

