/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIMessages;
import tern.eclipse.ide.tools.internal.ui.console.ConsoleDocument;
import tern.eclipse.ide.tools.internal.ui.console.TernRepositoryConsoleHelper;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.console.ITernConsole;
import tern.eclipse.ide.ui.console.LineType;

public class TernRepositoryConsole
extends MessageConsole
implements ITernConsole {
    private static TernRepositoryConsole INSTANCE;
    private boolean showOnMessage;
    private IConsoleManager consoleManager;
    private final ConsoleDocument document;
    private boolean visible = false;
    private MessageConsoleStream[] streams = new MessageConsoleStream[LineType.values().length];
    private boolean initialized;

    public TernRepositoryConsole() {
        super(TernToolsUIMessages.TernRepository_name, ImageResource.getImageDescriptor((String)"logo"));
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.document = new ConsoleDocument();
    }

    protected void init() {
        super.init();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TernRepositoryConsole.this.initializeStreams();
                TernRepositoryConsole.this.dump();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                int i = 0;
                while (i < this.streams.length) {
                    this.streams[i] = this.newMessageStream();
                    ++i;
                }
                i = 0;
                while (i < LineType.values().length) {
                    this.initializeStream(LineType.values()[i]);
                    ++i;
                }
                this.initialized = true;
            }
        }
    }

    private void initializeStream(LineType lineType) {
        Color color = this.createColor(Display.getDefault(), lineType);
        this.streams[lineType.ordinal()].setColor(color);
    }

    private Color createColor(Display display, LineType lineType) {
        RGB rgb = this.getRGB(lineType);
        return new Color((Device)display, rgb);
    }

    public RGB getRGB(LineType lineType) {
        switch (lineType) {
            case PROCESS_INFO: {
                return new RGB(0, 108, 54);
            }
            case PROCESS_ERROR: {
                return new RGB(255, 0, 0);
            }
        }
        return new RGB(0, 64, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.doAppendLine(line.getType(), line.getLine());
                ++i;
            }
            this.document.clear();
        }
    }

    public void doAppendLine(final LineType lineType, final String line) {
        Job appendJob = new Job(TernToolsUIMessages.TernRepositoryConsoleJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                TernRepositoryConsole.this.internalDoAppendLine(lineType, line);
                return Status.OK_STATUS;
            }
        };
        appendJob.setPriority(30);
        appendJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDoAppendLine(LineType lineType, String line) {
        this.showConsole();
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                this.streams[lineType.ordinal()].println(line);
            } else {
                this.document.appendConsoleLine(lineType, line);
            }
        }
    }

    private void showConsole() {
        this.show(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
        }
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this.showOnMessage) {
            if (!this.visible) {
                TernRepositoryConsoleHelper.showConsole(this);
            } else {
                this.consoleManager.showConsoleView((IConsole)this);
            }
        }
    }

    public static TernRepositoryConsole getConsole() {
        if (INSTANCE == null) {
            INSTANCE = new TernRepositoryConsole();
        }
        return INSTANCE;
    }

    public class MyLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == TernRepositoryConsole.this) {
                    TernRepositoryConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == TernRepositoryConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    TernRepositoryConsole.this.dispose();
                }
                ++i;
            }
        }
    }
}

