/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import tern.eclipse.ide.core.utils.FileUtils;
import tern.eclipse.ide.tools.internal.ui.wizards.IOperation;
import tern.eclipse.ide.tools.internal.ui.wizards.NewFileWizardPage;
import tern.utils.IOUtils;

public class NewFileOperation
implements IOperation {
    private final NewFileWizardPage page;
    private String containerName;
    private String fileName;

    public NewFileOperation(NewFileWizardPage page) {
        this.page = page;
    }

    @Override
    public void init() {
        this.containerName = this.page.getContainerName();
        this.fileName = this.page.getFileName();
    }

    public void run(IProgressMonitor monitor, Object model) throws CoreException {
        this.doFinish(this.containerName, this.fileName, monitor);
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Creating " + fileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(this.page.getModel(), file.getProject());
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.page.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(Object options, IProject project) {
        String contents = this.page.getGenerator(FileUtils.getLineSeparator((IProject)project)).generate(options);
        return IOUtils.toInputStream((String)contents);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "_wizard", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    @Override
    public int getTotal() {
        return 2;
    }
}

