/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernRepositoryManager;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.controls.AbstractTernModulePanel;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;

public class TernModuleDependenciesPanel
extends AbstractTernModulePanel {
    public TernModuleDependenciesPanel(Composite parent, ITernModule module, IProject project) {
        super(parent, module, project);
    }

    @Override
    protected void createUI(Composite parent, ITernModule module, IProject project) {
        GridLayout layout = new GridLayout(1, false);
        super.setLayout((Layout)layout);
        Table table = new Table(parent, 68096);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn(tableViewer, 0);
        nameColumn.getColumn().setWidth(180);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleName);
        tableViewer.setLabelProvider((IBaseLabelProvider)new TernModuleLabelProvider());
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        try {
            IIDETernProject ternProject = project != null ? TernCorePlugin.getTernProject((IProject)project) : null;
            ITernRepositoryManager repositoryManager = TernCorePlugin.getTernRepositoryManager();
            ArrayList<ITernModule> ternModules = new ArrayList<ITernModule>();
            TernModuleMetadata metadata = module.getMetadata();
            if (metadata != null) {
                ITernModule dependencyModule = null;
                Collection dependencies = metadata.getDependencies(module.getVersion());
                for (String dependency : dependencies) {
                    dependencyModule = repositoryManager.findTernModule(dependency, ternProject);
                    if (dependencyModule == null) continue;
                    ternModules.add(dependencyModule);
                }
            }
            tableViewer.setInput(ternModules);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while getting tern project", e);
        }
    }
}

