/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors.options;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.descriptors.options.LintRule;
import tern.eclipse.ide.internal.ui.viewers.LintRulesLabelProvider;
import tern.eclipse.ide.internal.ui.viewers.LintRulesSeverityEditingSupport;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.metadata.TernModuleMetadataOption;

public class LintRulesTernModuleOptionFactory
implements ITernModuleOptionFactory {
    @Override
    public void createOption(Composite parent, IProject project, TernModuleMetadataOption metadata, JsonObject options) {
        List<LintRule> rules = this.createRules(metadata, options);
        TableViewer viewer = new TableViewer(parent, 68354);
        TableViewerColumn ruleColumn = new TableViewerColumn(viewer, 0);
        ruleColumn.getColumn().setWidth(200);
        ruleColumn.getColumn().setResizable(true);
        ruleColumn.getColumn().setText(TernUIMessages.LintRulesTernModuleOptionFactory_rules_ruleColumn);
        TableViewerColumn severityColumn = new TableViewerColumn(viewer, 0);
        severityColumn.getColumn().setWidth(100);
        severityColumn.getColumn().setResizable(true);
        severityColumn.getColumn().setText(TernUIMessages.LintRulesTernModuleOptionFactory_rules_severityColumn);
        severityColumn.setEditingSupport((EditingSupport)new LintRulesSeverityEditingSupport((ColumnViewer)viewer));
        Table table = viewer.getTable();
        GridData data = new GridData(1808);
        data.widthHint = 350;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        viewer.setLabelProvider((IBaseLabelProvider)LintRulesLabelProvider.getInstance());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(rules);
    }

    private List<LintRule> createRules(TernModuleMetadataOption metadata, JsonObject options) {
        JsonObject rulesOption = (JsonObject)options.get("rules");
        if (rulesOption == null) {
            rulesOption = new JsonObject();
            options.set("rules", (JsonValue)rulesOption);
        }
        ArrayList<LintRule> rules = new ArrayList<LintRule>();
        JsonArray defaultRules = (JsonArray)metadata.getJsonObject().get("values");
        for (JsonObject defaultRule : defaultRules) {
            rules.add(new LintRule(defaultRule, rulesOption));
        }
        return rules;
    }
}

