/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors.options;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleDescriptorManager;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.eclipse.ide.ui.utils.DialogUtils;
import tern.metadata.TernModuleMetadataOption;
import tern.server.protocol.JsonHelper;
import tern.utils.StringUtils;

public class PathTernModuleOptionFactory
implements ITernModuleOptionFactory {
    @Override
    public void createOption(Composite ancestor, final IProject project, TernModuleMetadataOption metadata, final JsonObject options) {
        final String name = metadata.getName();
        if (project == null) {
            TernModuleDescriptorManager.getManager().getTernModuleOptionFactory("string").createOption(ancestor, project, metadata, options);
            return;
        }
        final Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(768));
        final Text textField = new Text(parent, 2048);
        textField.setLayoutData((Object)new GridData(768));
        final ControlDecoration deco = new ControlDecoration((Control)textField, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        deco.setDescriptionText(TernUIMessages.PathTernModuleOptionFactory_validatePath);
        deco.setImage(image);
        deco.hide();
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = textField.getText();
                if (StringUtils.isEmpty((String)value)) {
                    options.remove(name);
                } else {
                    IFolder folder = project.getFolder(value);
                    if (folder != null && folder.exists()) {
                        deco.hide();
                    } else {
                        deco.show();
                    }
                    options.set(name, value);
                }
            }
        });
        String initialValue = JsonHelper.getString((JsonValue)options.get(name));
        textField.setText(initialValue != null ? initialValue : "");
        Button pathButton = new Button(parent, 8);
        pathButton.setText(TernUIMessages.Button_selectPath);
        pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = DialogUtils.openFolderDialog(textField.getText(), project, false, parent.getShell());
                if (resource != null) {
                    String path = resource.getProjectRelativePath().toString();
                    textField.setText(path);
                }
            }
        });
    }
}

