/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.ui.hover.ITernHoverInfoProvider;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.jface.text.HoverLocationListener;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernQuery;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.definition.TernDefinitionQuery;
import tern.utils.StringUtils;

public class IDEHoverLocationListener
extends HoverLocationListener
implements ITernDefinitionCollector {
    private final ITernHoverInfoProvider provider;

    public IDEHoverLocationListener(BrowserInformationControl control, ITernHoverInfoProvider provider) {
        super(control);
        this.provider = provider;
    }

    protected void handleTernFileLink(String loc) {
        super.handleTernFileLink(loc);
        IFile file = this.provider.getTernProject().getIDEFile(loc);
        if (file.exists()) {
            EditorUtils.openInEditor(file, -1, -1, true);
        }
    }

    protected void handleTernDefinitionLink(String loc) {
        super.handleTernDefinitionLink(loc);
        ITernFile tf = this.provider.getFile();
        if (tf != null) {
            IIDETernProject ternProject = this.provider.getTernProject();
            Integer pos = this.provider.getOffset();
            TernDefinitionQuery query = new TernDefinitionQuery(tf.getFullName((ITernProject)ternProject), pos);
            try {
                ternProject.request((TernQuery)query, tf, (ITernResultsCollector)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setDefinition(String filename, Long start, Long end) {
        IFile file = this.getFile(filename);
        if (file != null && file.exists()) {
            EditorUtils.openInEditor(file, start != null ? start.intValue() : -1, start != null && end != null ? end.intValue() - start.intValue() : -1, true);
        }
    }

    private IFile getFile(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return null;
        }
        IIDETernProject ternProject = this.provider.getTernProject();
        return ternProject.getIDEFile(filename);
    }
}

