/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.properties;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import tern.EcmaVersion;
import tern.TernException;
import tern.eclipse.ide.core.IWorkingCopy;
import tern.eclipse.ide.core.IWorkingCopyListener;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.properties.AbstractTernPropertyPage;
import tern.eclipse.ide.ui.viewers.ECMAVersionLabelProvider;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.TernPlugin;

public class TernMainPropertyPage
extends AbstractTernPropertyPage
implements IWorkingCopyListener {
    private static final String STRONG_OPTION = "strong";
    public static final String PROP_ID = "tern.eclipse.ide.ui.properties";
    private Button useESModules;
    private Button useJSDoc;
    private Button jsdocStrong;
    private ComboViewer ecmaVersionViewer;

    public TernMainPropertyPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        IWorkingCopy workingCopy = this.getWorkingCopy();
        this.createECMAScriptComplianceContents(composite, workingCopy);
        this.createJSDocContents(composite, workingCopy);
        workingCopy.addWorkingCopyListener((IWorkingCopyListener)this);
        return composite;
    }

    private void createECMAScriptComplianceContents(Composite parent, final IWorkingCopy workingCopy) {
        Group ecmaGroup = new Group(parent, 16);
        ecmaGroup.setText(TernUIMessages.TernMainPropertyPage_ecmaGroup_label);
        ecmaGroup.setLayout((Layout)new GridLayout(2, false));
        ecmaGroup.setLayoutData((Object)new GridData(768));
        Label versionLabel = new Label((Composite)ecmaGroup, 0);
        versionLabel.setText(TernUIMessages.TernMainPropertyPage_ecmaVersion);
        versionLabel.setLayoutData((Object)new GridData(768));
        this.ecmaVersionViewer = new ComboViewer((Composite)ecmaGroup, 8);
        this.ecmaVersionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.ecmaVersionViewer.setLabelProvider((IBaseLabelProvider)ECMAVersionLabelProvider.INSTANCE);
        this.ecmaVersionViewer.setInput((Object)EcmaVersion.values());
        this.ecmaVersionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TernMainPropertyPage.this.updateUseESModules(workingCopy);
            }
        });
        this.useESModules = new Button((Composite)ecmaGroup, 32);
        this.useESModules.setText(TernUIMessages.TernMainPropertyPage_useESModules);
        this.useESModules.setEnabled(false);
        this.ecmaVersionViewer.setSelection((ISelection)new StructuredSelection((Object)workingCopy.getEcmaVersion()));
        this.useESModules.setSelection(workingCopy.hasCheckedTernModule(TernPlugin.es_modules.getName()));
        this.useESModules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITernModule esModules = TernMainPropertyPage.this.getESModules(workingCopy);
                if (TernMainPropertyPage.this.useESModules.getSelection()) {
                    workingCopy.getCheckedModules().add(esModules);
                } else {
                    workingCopy.getCheckedModules().remove(esModules);
                }
            }
        });
    }

    private void updateUseESModules(IWorkingCopy workingCopy) {
        EcmaVersion ecmaVersion = this.getEcmaVersion();
        this.useESModules.setEnabled(ecmaVersion.getVersion() >= 6);
        if (!this.useESModules.isEnabled()) {
            this.useESModules.setSelection(false);
        }
        workingCopy.setEcmaVersion(ecmaVersion);
    }

    protected EcmaVersion getEcmaVersion() {
        IStructuredSelection selection = (IStructuredSelection)this.ecmaVersionViewer.getSelection();
        EcmaVersion version = (EcmaVersion)selection.getFirstElement();
        return version;
    }

    private void createJSDocContents(Composite parent, final IWorkingCopy workingCopy) {
        Group jsdocGroup = new Group(parent, 16);
        jsdocGroup.setText(TernUIMessages.TernMainPropertyPage_jsdocGroup_label);
        jsdocGroup.setLayout((Layout)new GridLayout());
        jsdocGroup.setLayoutData((Object)new GridData(768));
        this.useJSDoc = new Button((Composite)jsdocGroup, 32);
        this.useJSDoc.setText(TernUIMessages.TernMainPropertyPage_useJSDoc);
        this.useJSDoc.setLayoutData((Object)new GridData(768));
        this.useJSDoc.setToolTipText(TernUIMessages.TernMainPropertyPage_useJSDoc_tooltipText);
        this.jsdocStrong = new Button((Composite)jsdocGroup, 32);
        this.jsdocStrong.setText(TernUIMessages.TernMainPropertyPage_JSDocStrong);
        this.jsdocStrong.setLayoutData((Object)new GridData(768));
        this.jsdocStrong.setToolTipText(TernUIMessages.TernMainPropertyPage_JSDocStrong_tooltipText);
        this.useJSDoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = TernMainPropertyPage.this.useJSDoc.getSelection();
                ITernModuleConfigurable docComment = TernMainPropertyPage.this.getDocComment(workingCopy);
                if (!workingCopy.hasCheckedTernModule(TernPlugin.doc_comment.getName())) {
                    workingCopy.getCheckedModules().add(docComment);
                }
                if (enabled) {
                    docComment.setOptions(null);
                } else {
                    docComment.setOptions(JsonValue.NULL);
                }
                TernMainPropertyPage.this.jsdocStrong.setEnabled(enabled);
            }
        });
        this.jsdocStrong.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ITernModuleConfigurable docComment = TernMainPropertyPage.this.getDocComment(workingCopy);
                if (!workingCopy.hasCheckedTernModule(TernPlugin.doc_comment.getName())) {
                    workingCopy.getCheckedModules().add(docComment);
                }
                JsonObject options = null;
                if (TernMainPropertyPage.this.jsdocStrong.getSelection()) {
                    options = new JsonObject();
                    options.set(TernMainPropertyPage.STRONG_OPTION, true);
                }
                docComment.setOptions(options);
            }
        });
        if (this.isJSDocEnabled(workingCopy)) {
            this.useJSDoc.setSelection(true);
            this.jsdocStrong.setEnabled(true);
            JsonObject options = this.getDocComment(workingCopy).getOptionsObject();
            if (options != null) {
                this.jsdocStrong.setSelection(options.getBoolean(STRONG_OPTION, false));
            }
        } else {
            this.jsdocStrong.setEnabled(false);
        }
    }

    private boolean isJSDocEnabled(IWorkingCopy workingCopy) {
        ITernModuleConfigurable docComment;
        JsonValue value;
        return !workingCopy.hasCheckedTernModule(TernPlugin.doc_comment.getName()) || (value = (docComment = this.getDocComment(workingCopy)).getOptions()) == null || !value.isNull() && !value.isFalse();
    }

    @Override
    protected void doPerformOk() throws Exception {
    }

    public void moduleSelectionChanged(ITernModule module, boolean selected) {
        if (TernPlugin.doc_comment.getName().equals(module.getName())) {
            this.useJSDoc.setSelection(selected);
        } else if (TernPlugin.es_modules.getName().equals(module.getName())) {
            this.useESModules.setSelection(selected);
        }
    }

    private ITernModuleConfigurable getDocComment(IWorkingCopy workingCopy) {
        try {
            return (ITernModuleConfigurable)workingCopy.getTernModule(TernPlugin.doc_comment.getName());
        }
        catch (TernException e) {
            Trace.trace((byte)3, "Error while getting tern module from working copy", e);
            return null;
        }
    }

    private ITernModule getESModules(IWorkingCopy workingCopy) {
        try {
            return workingCopy.getTernModule(TernPlugin.es_modules.getName());
        }
        catch (TernException e) {
            Trace.trace((byte)3, "Error while getting tern module from working copy", e);
            return null;
        }
    }
}

