/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.viewers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.utils.TernModuleHelper;

public class TernModuleLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final ITableLabelProvider INSTANCE = new TernModuleLabelProvider();

    public static ITableLabelProvider getInstance() {
        return INSTANCE;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ITernModule) {
            ITernModule module = (ITernModule)element;
            switch (columnIndex) {
                case 0: {
                    return TernModuleHelper.getLabel((ITernModule)module);
                }
                case 1: {
                    String version = module.getVersion();
                    return version != null ? version : "";
                }
            }
        }
        return element.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (!(element instanceof ITernModule)) break;
                return TernModuleLabelProvider.getImageModule((ITernModule)element);
            }
        }
        return null;
    }

    public static Image getImageModule(ITernModule module) {
        Image image = TernUIPlugin.getTernDescriptorManager().getImage(module);
        if (image != null) {
            return image;
        }
        return TernModuleLabelProvider.getDefaultImage(module);
    }

    private static Image getDefaultImage(ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                return ImageResource.getImage("typedef");
            }
            case Plugin: {
                return ImageResource.getImage("plugin");
            }
            case Configurable: {
                return TernModuleLabelProvider.getDefaultImage(((ITernModuleConfigurable)module).getWrappedModule());
            }
        }
        return null;
    }
}

