/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.ide.ui.views.AbstractTernContentOutlinePage;
import tern.eclipse.ide.ui.views.AbstractTernOutlineView;
import tern.server.protocol.outline.IJSNode;

class ActivateEditorJob
extends UIJob {
    private static final int UPDATE_DELAY = 100;
    private final AbstractTernOutlineView view;
    private IJSNode currentNodeToOpen;

    public ActivateEditorJob(AbstractTernOutlineView view) {
        super(TernUIMessages.Link_With_Editor_Job_);
        super.setSystem(true);
        super.setPriority(20);
        this.view = view;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        AbstractTernContentOutlinePage page = this.view.getCurrentTernPage();
        if (page != null) {
            try {
                this.view.ignoreEditorActivation = true;
                IFile file = page.getFile();
                if (file != null) {
                    EditorUtils.openInEditor(this.currentNodeToOpen, file);
                } else {
                    EditorUtils.openInEditor(this.currentNodeToOpen);
                }
            }
            finally {
                this.view.ignoreEditorActivation = false;
            }
        }
        return Status.OK_STATUS;
    }

    public void openInEditor(IJSNode node, boolean force) {
        AbstractTernContentOutlinePage page = this.view.getCurrentTernPage();
        if (page == null) {
            return;
        }
        if (!(force || this.view.isLinkingEnabled() && !this.view.ignoreSelectionChanged)) {
            return;
        }
        this.currentNodeToOpen = node;
        this.schedule(100L);
    }
}

