/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.views.AbstractTernContentOutlinePage;
import tern.eclipse.ide.ui.views.AbstractTernOutlineView;
import tern.eclipse.ide.ui.views.IOutlineProvider;
import tern.server.protocol.outline.IJSNode;
import tern.server.protocol.outline.IJSNodeRoot;
import tern.server.protocol.outline.TernOutlineCollector;

class RefreshOutlineJob
extends Job
implements IOutlineProvider {
    private static final int UPDATE_DELAY = 500;
    private final AbstractTernOutlineView view;
    private IOutlineProvider.State state;
    private TernOutlineCollector outline;

    public RefreshOutlineJob(AbstractTernOutlineView view) {
        super(TernUIMessages.refreshOutline);
        super.setSystem(true);
        super.setPriority(20);
        this.view = view;
    }

    protected IStatus run(IProgressMonitor monitor) {
        final CommonViewer viewer = this.view.getCurrentViewer();
        if (viewer == null) {
            return Status.OK_STATUS;
        }
        AbstractTernContentOutlinePage page = this.view.getCurrentTernPage();
        IFile file = page.getCurrentFile();
        this.state = !this.view.isOutlineAvailable(file) ? IOutlineProvider.State.Unavailable : IOutlineProvider.State.Computing;
        if (viewer.getInput() == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Control refreshControl = viewer.getControl();
                    if (refreshControl != null && !refreshControl.isDisposed()) {
                        viewer.setInput((Object)RefreshOutlineJob.this);
                    }
                }
            });
        }
        if (this.state != IOutlineProvider.State.Unavailable) {
            try {
                IDocument document = page.getCurrentDocument();
                this.outline = this.view.loadOutline(file, document);
                if (this.outline != null) {
                    this.state = IOutlineProvider.State.Done;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Control refreshControl = viewer.getControl();
                            if (refreshControl != null && !refreshControl.isDisposed()) {
                                TreePath[] expendedPaths = null;
                                if (viewer instanceof TreeViewer) {
                                    expendedPaths = viewer.getExpandedTreePaths();
                                }
                                viewer.refresh();
                                if (viewer instanceof TreeViewer && expendedPaths != null) {
                                    viewer.setExpandedTreePaths(RefreshOutlineJob.this.toNewTreePaths(expendedPaths, (IJSNode)RefreshOutlineJob.this.outline.getRoot()));
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                return new Status(4, "tern.eclipse.ide.ui", "Error while loading tern outline...", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private TreePath[] toNewTreePaths(TreePath[] originExpandedPaths, IJSNode newRoot) {
        ArrayList<TreePath> res = new ArrayList<TreePath>();
        TreePath[] treePathArray = originExpandedPaths;
        int n = originExpandedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath originExpanded = treePathArray[n2];
            int i = 0;
            ArrayList<Object> newPathItems = new ArrayList<Object>();
            IJSNode previousJSNode = null;
            while (i < originExpanded.getSegmentCount()) {
                Object originSegment = originExpanded.getSegment(i);
                if (originSegment instanceof IJSNode) {
                    IJSNode originNode = (IJSNode)originSegment;
                    IJSNode matchingNode = null;
                    matchingNode = previousJSNode == null ? (originNode instanceof IJSNodeRoot ? newRoot : this.findSimilarChild(newRoot, originNode)) : this.findSimilarChild(previousJSNode, originNode);
                    if (matchingNode != null) {
                        newPathItems.add(matchingNode);
                        previousJSNode = matchingNode;
                    }
                } else {
                    newPathItems.add(originSegment);
                }
                ++i;
            }
            res.add(new TreePath(newPathItems.toArray()));
            ++n2;
        }
        return res.toArray(new TreePath[res.size()]);
    }

    private IJSNode findSimilarChild(IJSNode newParentNode, IJSNode originChildNode) {
        int index;
        IJSNode matchingNode = null;
        if (originChildNode.getName() != null) {
            for (IJSNode child : newParentNode.getChildren()) {
                if (child.getName() == null || !child.getName().equals(originChildNode.getName())) continue;
                matchingNode = child;
            }
        }
        if (matchingNode == null && (index = originChildNode.getParent().getChildren().indexOf(originChildNode)) >= 0 && newParentNode.getChildren().size() > index) {
            matchingNode = (IJSNode)newParentNode.getChildren().get(index);
        }
        return matchingNode;
    }

    @Override
    public IOutlineProvider.State getOutlineState() {
        return this.state;
    }

    @Override
    public IJSNode getRoot() {
        return this.outline != null ? this.outline.getRoot() : null;
    }

    public void refreshOutline() {
        if (this.getState() != 0) {
            this.cancel();
        }
        this.schedule(500L);
    }
}

