/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.images;

import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.jface.images.TernCompositeImageDescriptor;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.server.protocol.completions.TernCompletionItem;
import tern.server.protocol.completions.TernTypeHelper;
import tern.utils.StringUtils;

public class TernImagesRegistry {
    public static final String IMG_FN = "tern.eclipse.jface.IMG_FN";
    public static final String IMG_ARRAY = "tern.eclipse.jface.IMG_ARRAY";
    public static final String IMG_NUMBER = "tern.eclipse.jface.IMG_NUMBER";
    public static final String IMG_STRING = "tern.eclipse.jface.IMG_STRING";
    public static final String IMG_BOOLEAN = "tern.eclipse.jface.IMG_BOOLEAN";
    public static final String IMG_UNKNOWN = "tern.eclipse.jface.IMG_UNKNOWN";
    public static final String IMG_CLASS = "tern.eclipse.jface.IMG_CLASS";
    public static final String IMG_IMPORT = "tern.eclipse.jface.IMG_IMPORT";

    static {
        TernImagesRegistry.registerImageDescriptor(IMG_FN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"fn.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_FN), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"fn_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_ARRAY, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"array.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_ARRAY), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"array_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_NUMBER, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"number.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_NUMBER), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"number_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_STRING, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"string.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_STRING), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"string_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_BOOLEAN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"boolean.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_BOOLEAN), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"boolean_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_UNKNOWN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"unknown.gif"));
        TernImagesRegistry.registerImageDescriptor(TernImagesRegistry.getOvr(IMG_UNKNOWN), ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"unknown_ovr.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_CLASS, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"class.gif"));
        TernImagesRegistry.registerImageDescriptor(IMG_IMPORT, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"import.png"));
    }

    private TernImagesRegistry() {
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        return imageRegistry.getDescriptor(key);
    }

    public static String getJSType(String jsType, boolean isFunction, boolean isArray, boolean returnNullIfUnknown) {
        if (isFunction) {
            return IMG_FN;
        }
        if (isArray) {
            return IMG_ARRAY;
        }
        if (TernTypeHelper.isStringType((String)jsType)) {
            return IMG_STRING;
        }
        if (TernTypeHelper.isNumberType((String)jsType)) {
            return IMG_NUMBER;
        }
        if (TernTypeHelper.isBoolType((String)jsType)) {
            return IMG_BOOLEAN;
        }
        if (TernTypeHelper.isFunctionRefType((String)jsType)) {
            return IMG_FN;
        }
        if (returnNullIfUnknown) {
            return null;
        }
        return IMG_UNKNOWN;
    }

    public static Image getImage(String jsType, boolean isFunction, boolean isArray, boolean returnNullIfUnknown) {
        String key = TernImagesRegistry.getJSType(jsType, isFunction, isArray, returnNullIfUnknown);
        return key != null ? TernImagesRegistry.getImage(key) : null;
    }

    public static String getJSType(TernCompletionItem item, boolean returnNullIfUnknown) {
        return TernImagesRegistry.getJSType(item.getJsType(), item.isFunction(), item.isArray(), returnNullIfUnknown);
    }

    public static Image getImage(TernCompletionItem item, boolean returnNullIfUnknown) {
        String key = TernImagesRegistry.getJSType(item, returnNullIfUnknown);
        return key != null ? TernImagesRegistry.getImage(key) : null;
    }

    public static ImageDescriptor getImageDescriptor(TernCompletionItem item, boolean returnNullIfUnknown) {
        String key = TernImagesRegistry.getJSType(item, returnNullIfUnknown);
        return key != null ? TernImagesRegistry.getImageDescriptor(key) : null;
    }

    private static void registerImageDescriptor(String key, ImageDescriptor descriptor) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageRegistry.put(key, descriptor);
    }

    static String getOvr(String typeKey) {
        return typeKey + "_ovr";
    }

    public static Image getImage(ITernModule module) {
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata == null) {
            return null;
        }
        File icon = metadata.getFileIcon();
        if (icon == null) {
            return null;
        }
        String key = icon.getPath();
        Image image = TernImagesRegistry.getImage(key);
        if (image != null) {
            return image;
        }
        ImageDescriptor desc = ImageDescriptor.createFromFile(null, (String)icon.getPath());
        TernImagesRegistry.registerImageDescriptor(key, desc);
        return TernImagesRegistry.getImage(key);
    }

    public static Image getImage(String jsType, ITernModule module) {
        boolean hasOrigin;
        boolean hasJSType = !StringUtils.isEmpty((String)jsType);
        boolean bl = hasOrigin = module != null;
        if (!hasJSType) {
            Image originImage = hasOrigin ? TernImagesRegistry.getImage(module) : null;
            return originImage != null ? originImage : TernImagesRegistry.getImage(IMG_UNKNOWN);
        }
        if (!hasOrigin) {
            return TernImagesRegistry.getImage(jsType);
        }
        String imageKey = TernImagesRegistry.getImageKey(jsType, module.getOrigin());
        Image image = TernImagesRegistry.getImage(imageKey);
        if (image != null) {
            return image;
        }
        ImageDescriptor originImageDescriptor = TernImagesRegistry.getImageDescriptor(module);
        if (originImageDescriptor == null) {
            return TernImagesRegistry.getImage(jsType);
        }
        TernCompositeImageDescriptor desc = new TernCompositeImageDescriptor(originImageDescriptor, jsType);
        TernImagesRegistry.registerImageDescriptor(imageKey, (ImageDescriptor)desc);
        return TernImagesRegistry.getImage(imageKey);
    }

    public static ImageDescriptor getImageDescriptor(ITernModule module) {
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata == null) {
            return null;
        }
        File icon = metadata.getFileIcon();
        if (icon == null) {
            return null;
        }
        String key = icon.getPath();
        ImageDescriptor desc = TernImagesRegistry.getImageDescriptor(key);
        if (desc != null) {
            return desc;
        }
        desc = ImageDescriptor.createFromFile(null, (String)icon.getPath());
        TernImagesRegistry.registerImageDescriptor(key, desc);
        return desc;
    }

    private static String getImageKey(String jsType, String origin) {
        return String.valueOf(jsType) + "_" + origin;
    }

    public static ImageDescriptor getImageDescriptor(String jsType, ITernModule module) {
        boolean hasOrigin;
        boolean hasJSType = !StringUtils.isEmpty((String)jsType);
        boolean bl = hasOrigin = module != null;
        if (!hasJSType) {
            ImageDescriptor originImage = hasOrigin ? TernImagesRegistry.getImageDescriptor(module) : null;
            return originImage != null ? originImage : TernImagesRegistry.getImageDescriptor(IMG_UNKNOWN);
        }
        if (!hasOrigin) {
            return TernImagesRegistry.getImageDescriptor(jsType);
        }
        String imageKey = TernImagesRegistry.getImageKey(jsType, module.getOrigin());
        ImageDescriptor image = TernImagesRegistry.getImageDescriptor(imageKey);
        if (image != null) {
            return image;
        }
        ImageDescriptor originImageDescriptor = TernImagesRegistry.getImageDescriptor(module);
        if (originImageDescriptor == null) {
            return TernImagesRegistry.getImageDescriptor(IMG_UNKNOWN);
        }
        TernCompositeImageDescriptor desc = new TernCompositeImageDescriptor(originImageDescriptor, jsType);
        TernImagesRegistry.registerImageDescriptor(imageKey, (ImageDescriptor)desc);
        return TernImagesRegistry.getImageDescriptor(imageKey);
    }
}

