/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import tern.ITernProject;
import tern.TernException;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernQuery;
import tern.server.protocol.highlight.ITernHighlightCollector;
import tern.server.protocol.highlight.TernHighlightQuery;

public abstract class TernTokenScanner
implements ITokenScanner {
    private static final Comparator<TernToken> TERN_TOKEN_COMPARATOR = new Comparator<TernToken>(){

        @Override
        public int compare(TernToken t1, TernToken t2) {
            return (int)(t1.end - t2.end);
        }
    };
    private final List<TernToken> tokens = new ArrayList<TernToken>();
    private TernToken current;
    private int index;

    public void setRange(IDocument document, int offset, int length) {
        this.tokens.clear();
        this.index = 0;
        TernTokenList collector = new TernTokenList(offset, length);
        try {
            this.highlight(document, collector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(collector, TERN_TOKEN_COMPARATOR);
        TernToken lastToken = null;
        for (TernToken ternToken : collector) {
            if (lastToken != null) {
                this.tokens.add(new TernToken("", lastToken.end, ternToken.start, null));
            }
            this.tokens.add(ternToken);
            lastToken = ternToken;
        }
        if (lastToken != null) {
            this.tokens.add(new TernToken("", lastToken.end, Long.valueOf(length + offset), null));
        } else {
            this.tokens.add(new TernToken("", Long.valueOf(offset), Long.valueOf(length + offset), null));
        }
    }

    private void highlight(IDocument document, TernTokenList collector) throws CoreException, BadLocationException, IOException, TernException {
        ITernProject ternProject = this.getTernProject(document);
        if (ternProject != null) {
            String text = document.get(collector.getOffset(), collector.getLength());
            TernHighlightQuery query = new TernHighlightQuery(text);
            ternProject.request((TernQuery)query, null, (ITernResultsCollector)collector);
        }
    }

    public IToken nextToken() {
        if (this.index < this.tokens.size()) {
            this.current = this.tokens.get(this.index);
            ++this.index;
            return this.current;
        }
        return Token.EOF;
    }

    public int getTokenOffset() {
        return this.current.getOffset();
    }

    public int getTokenLength() {
        return this.current.getLength();
    }

    protected abstract TextAttribute getTextAttribute(String var1);

    protected abstract ITernProject getTernProject(IDocument var1) throws CoreException;

    private class TernToken
    extends Token {
        public final String type;
        public final Long start;
        public final Long end;

        public TernToken(String type, Long start, Long end, TextAttribute attribute) {
            super((Object)attribute);
            this.type = type;
            this.start = start;
            this.end = end;
        }

        public int getLength() {
            if (this.end.intValue() - this.start.intValue() < 0) {
                System.err.println("Arghhh!!!");
            }
            return this.end.intValue() - this.start.intValue();
        }

        public int getOffset() {
            return this.start.intValue();
        }
    }

    private class TernTokenList
    extends ArrayList<TernToken>
    implements ITernHighlightCollector {
        private final int offset;
        private final int length;

        public TernTokenList(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public void higlight(String type, Long start, Long end) {
            TextAttribute attribute = TernTokenScanner.this.getTextAttribute(type);
            super.add(new TernToken(type, start + (long)this.offset, end + (long)this.offset, attribute));
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

