/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.ArrayList;
import java.util.List;
import org.dadacoalition.yedit.editor.YEdit;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceChangeListener
implements IPropertyChangeListener {
    private final YEdit editor;
    private static List<String> sourceConfigurationRelatedProperties = PreferenceChangeListener.initSourceConfigurationRelatedProperties();

    public PreferenceChangeListener(YEdit editor) {
        this.editor = editor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (this.isMarkErrorRelatedProperty(propertyName)) {
            this.editor.markErrors();
            this.editor.updateContentOutline();
        }
        if (this.isOutlineRelatedProperty(propertyName)) {
            this.editor.updateContentOutline();
        }
        if (this.isSourceConfigurationRelatedProperty(propertyName)) {
            this.editor.reinitialize();
        }
    }

    private boolean isMarkErrorRelatedProperty(String propertyName) {
        return propertyName.equals("validation") || propertyName.equals("symfonyCompatibilityMode");
    }

    private boolean isOutlineRelatedProperty(String propertyName) {
        return propertyName.equals("outlineScalarMaxLength") || propertyName.equals("outlineShowTags");
    }

    private boolean isSourceConfigurationRelatedProperty(String propertyName) {
        return sourceConfigurationRelatedProperties.contains(propertyName);
    }

    private static List<String> initSourceConfigurationRelatedProperties() {
        ArrayList<String> relatedProperties = new ArrayList<String>();
        relatedProperties.add("secondsToReevaluate");
        relatedProperties.add("spacesPerTab");
        relatedProperties.add("colorCommentPreference");
        relatedProperties.add("boldCommentPreference");
        relatedProperties.add("italicCommentPreference");
        relatedProperties.add("underlineCommentPreference");
        relatedProperties.add("colorKeyPreference");
        relatedProperties.add("boldKeyPreference");
        relatedProperties.add("italicKeyPreference");
        relatedProperties.add("underlineKeyPreference");
        relatedProperties.add("colorScalarPreference");
        relatedProperties.add("boldScalarPreference");
        relatedProperties.add("italicScalarPreference");
        relatedProperties.add("underlineScalarPreference");
        relatedProperties.add("colorDefaultPreference");
        relatedProperties.add("boldDefaultPreference");
        relatedProperties.add("italicDefaultPreference");
        relatedProperties.add("underlineDefaulPreference");
        relatedProperties.add("colorDocumentPreference");
        relatedProperties.add("boldDocumentPreference");
        relatedProperties.add("italicDocumentPreference");
        relatedProperties.add("underlineDocumentPreference");
        relatedProperties.add("colorAnchorPreferences");
        relatedProperties.add("boldAnchorPreference");
        relatedProperties.add("italicAnchorPreference");
        relatedProperties.add("underlineAnchorPreference");
        relatedProperties.add("colorAliasPreferences");
        relatedProperties.add("boldAliasPreference");
        relatedProperties.add("italicAliasPreference");
        relatedProperties.add("underlineAliasPreference");
        relatedProperties.add("colorTagPropertyPreferences");
        relatedProperties.add("boldTagPropertyPreference");
        relatedProperties.add("italicTagPropertyPreference");
        relatedProperties.add("underlineTagPropertyPreference");
        relatedProperties.add("colorFlowCharacterPreferences");
        relatedProperties.add("boldFlowCharacterPreference");
        relatedProperties.add("italicFlowCharacterPreference");
        relatedProperties.add("underlineFlowCharacterPreference");
        relatedProperties.add("colorConstantPreferences");
        relatedProperties.add("boldConstantPreference");
        relatedProperties.add("italicConstantPreference");
        relatedProperties.add("underlineConstantPreference");
        return relatedProperties;
    }
}

