/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.ArrayList;
import java.util.List;
import org.dadacoalition.yedit.YEditLog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YAMLOutlineElement {
    public static final int MAPPINGITEM = 1;
    public static final int SEQUENCEITEM = 2;
    public static final int DOCUMENT = 3;
    protected Node node;
    protected String key;
    protected String value;
    protected YAMLOutlineElement parent;
    protected List<YAMLOutlineElement> children = new ArrayList<YAMLOutlineElement>();
    protected Position position;
    protected IDocument document;
    protected int type;
    protected List<Integer> nodePath = new ArrayList<Integer>();

    protected YAMLOutlineElement(Node node, IDocument document) {
        this(node, null, 3, document);
    }

    protected YAMLOutlineElement(Node node, YAMLOutlineElement parent, int type, IDocument document) {
        this.node = node;
        this.parent = parent;
        this.type = type;
        this.document = document;
        if (this.parent != null) {
            this.nodePath = parent.nodePath;
        }
        this.nodePath.add(System.identityHashCode(this.node));
        this.parseNode(node);
        this.position = this.getPosition(node);
        try {
            document.addPosition("_____YAML_Element", this.position);
        }
        catch (BadLocationException e) {
            YEditLog.logger.warning(e.toString());
        }
        catch (BadPositionCategoryException e) {
            YEditLog.logger.warning(e.toString());
        }
    }

    private Position getPosition(Node node) {
        int startLine = node.getStartMark().getLine();
        int startColumn = node.getStartMark().getColumn();
        int endLine = node.getEndMark().getLine();
        int endColumn = node.getEndMark().getColumn();
        Position p = null;
        try {
            int offset = this.document.getLineOffset(startLine);
            int length = startLine < endLine ? this.document.getLineLength(startLine) - startColumn : endColumn - startColumn;
            p = new Position(offset += startColumn, length);
        }
        catch (BadLocationException e) {
            YEditLog.logger.warning(e.toString());
        }
        return p;
    }

    private void parseNode(Node node) {
        block2: {
            block3: {
                if (node instanceof ScalarNode) break block2;
                if (!(node instanceof SequenceNode)) break block3;
                SequenceNode sNode = (SequenceNode)node;
                List children = sNode.getValue();
                for (Node childNode : children) {
                    if (this.nodePath.contains(System.identityHashCode(childNode))) continue;
                    YAMLOutlineElement child = new YAMLOutlineElement(childNode, this, 2, this.document);
                    this.children.add(child);
                }
                break block2;
            }
            if (!(node instanceof MappingNode)) break block2;
            MappingNode mNode = (MappingNode)node;
            List children = mNode.getValue();
            for (NodeTuple childNode : children) {
                if (this.nodePath.contains(System.identityHashCode(childNode.getValueNode()))) continue;
                Node keyNode = childNode.getKeyNode();
                String key = keyNode instanceof ScalarNode ? ((ScalarNode)keyNode).getValue() : keyNode.toString();
                YAMLOutlineElement child = new YAMLOutlineElement(childNode.getValueNode(), this, 1, this.document);
                child.key = key;
                this.children.add(child);
            }
        }
    }

    public String toString() {
        if (this.type == 3) {
            return "";
        }
        if (this.type == 1) {
            if (this.children.size() == 0) {
                if (this.node instanceof ScalarNode) {
                    return String.valueOf(this.key) + ": " + ((ScalarNode)this.node).getValue();
                }
                return String.valueOf(this.key) + ": " + this.node.toString();
            }
            return this.key;
        }
        if (this.type == 2) {
            if (this.children.size() == 0) {
                if (this.node instanceof ScalarNode) {
                    return ((ScalarNode)this.node).getValue();
                }
                return this.node.toString();
            }
            return "";
        }
        return super.toString();
    }
}

