/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.Arrays;
import java.util.Map;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.editor.ColorManager;
import org.dadacoalition.yedit.editor.ContentTypeIdForYaml;
import org.dadacoalition.yedit.editor.YEditDamageRepairer;
import org.dadacoalition.yedit.editor.YEditDoubleClickStrategy;
import org.dadacoalition.yedit.editor.scanner.YAMLScanner;
import org.dadacoalition.yedit.template.YEditCompletionProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class YEditSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected YAMLScanner yamlScanner;
    protected ColorManager colorManager = new ColorManager();

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler pr = new PresentationReconciler();
        YEditDamageRepairer dr = new YEditDamageRepairer((ITokenScanner)this.getScanner());
        pr.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        pr.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return pr;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        YEditCompletionProcessor cap = new YEditCompletionProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ca.enableAutoInsert(true);
        return ca;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            int tabWidth = this.getTabWidth(sourceViewer);
            TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
            tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            return new IAutoEditStrategy[]{tabToSpacesConverter, new DefaultIndentLineAutoEditStrategy()};
        }
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        return prefs.getInt("spacesPerTab");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        int tabWidth = this.getTabWidth(sourceViewer);
        String[] indentPrefixes = new String[tabWidth];
        int prefixLength = 1;
        while (prefixLength <= tabWidth) {
            char[] spaceChars = new char[prefixLength];
            Arrays.fill(spaceChars, ' ');
            indentPrefixes[tabWidth - prefixLength] = new String(spaceChars);
            ++prefixLength;
        }
        return indentPrefixes;
    }

    protected YAMLScanner getScanner() {
        if (this.yamlScanner == null) {
            this.yamlScanner = new YAMLScanner(this.colorManager);
        }
        return this.yamlScanner;
    }

    public String[] getDefaultPrefixes(ISourceViewer viewer, String contentType) {
        return new String[]{"#", ""};
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put(ContentTypeIdForYaml.CONTENT_TYPE_ID_YAML, null);
        return targets;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new YEditDoubleClickStrategy();
    }
}

