/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class KeyRule
implements IRule {
    private IToken token;
    private Pattern keyPattern;

    public KeyRule(IToken token) {
        this.token = token;
        this.keyPattern = Pattern.compile(this.getKeyRegex(), 36);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        String stream = "";
        int c = scanner.read();
        int count = 1;
        boolean foundColon = false;
        while (c != -1) {
            stream = String.valueOf(stream) + (char)c;
            if (10 == c || 13 == c) break;
            if (58 == c) {
                foundColon = true;
                stream = String.valueOf(stream) + (char)scanner.read();
                ++count;
                break;
            }
            c = scanner.read();
            ++count;
        }
        if (!foundColon) {
            this.rewindScanner(scanner, count);
            return Token.UNDEFINED;
        }
        Matcher m = this.keyPattern.matcher(stream);
        if (m.matches()) {
            String matchedText = m.group(1);
            count -= matchedText.length();
            int i = 0;
            while (i < count) {
                scanner.unread();
                ++i;
            }
            return this.token;
        }
        this.rewindScanner(scanner, count);
        return Token.UNDEFINED;
    }

    private void rewindScanner(ICharacterScanner scanner, int stepsBack) {
        int i = 0;
        while (i < stepsBack) {
            scanner.unread();
            ++i;
        }
    }

    protected String getKeyRegex() {
        return "([\\w \\- _ +] [\\w \\s \\. \\\\ \\- _ +]*:)\\s.*";
    }
}

