/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.handlers;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.YEditMessages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class ToggleCommentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TextSelection)) {
            return null;
        }
        TextSelection ts = (TextSelection)selection;
        YEditLog.logger.info(String.valueOf(ts.getStartLine()) + " " + ts.getEndLine());
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editorPart instanceof TextEditor) && !(editorPart instanceof MultiPageEditorPart)) {
            YEditLog.logger.warning("Editor is not a TextEditor. Should always be so for the Toogle Comment action");
            return null;
        }
        TextEditor textEditor = null;
        if (editorPart instanceof MultiPageEditorPart) {
            IEditorPart[] editors;
            MultiPageEditorPart mpe = (MultiPageEditorPart)editorPart;
            IEditorPart[] iEditorPartArray = editors = mpe.findEditors(mpe.getEditorInput());
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editor = iEditorPartArray[n2];
                if (editor instanceof TextEditor) {
                    textEditor = (TextEditor)editor;
                    YEditLog.logger.info("Found text editor for the MultiPageEditorPart");
                    break;
                }
                ++n2;
            }
            if (textEditor == null) {
                YEditLog.logger.warning("The MultiPageEditorPart did not have a TextEditor. Cannot toggle comments");
                return null;
            }
        } else {
            textEditor = (TextEditor)editorPart;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ResourceBundle b = YEditMessages.getResourceBundle();
        TextOperationAction action = ToggleCommentHandler.addComment(document, ts) ? new TextOperationAction(b, "", (ITextEditor)textEditor, 11) : new TextOperationAction(b, "", (ITextEditor)textEditor, 12);
        action.run();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addComment(IDocument document, TextSelection selection) {
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        try {
            int lineNum = startLine;
            while (true) {
                if (lineNum > endLine) {
                    return false;
                }
                int offsetAtStart = document.getLineOffset(lineNum);
                int lineLength = document.getLineLength(lineNum);
                String lineText = document.get(offsetAtStart, lineLength);
                YEditLog.logger.info("Checking line " + lineNum + " with text " + lineText);
                if (!ToggleCommentHandler.startsWithComment(lineText)) {
                    return true;
                }
                ++lineNum;
            }
        }
        catch (BadLocationException ex) {
            YEditLog.logger.warning("BadLocationException when trying to toggle comments\n" + (Object)((Object)ex));
            return false;
        }
    }

    public static boolean startsWithComment(String line) {
        if (line == null) {
            return false;
        }
        Pattern commentPattern = Pattern.compile("^\\s*#.*", 32);
        Matcher m = commentPattern.matcher(line);
        boolean match = m.matches();
        YEditLog.logger.info("Match result was " + match + " for '" + line + "'");
        return match;
    }
}

