/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.preferences;

import java.util.ArrayList;
import org.dadacoalition.yedit.Activator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ColorPreferences
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private ArrayList<FieldEditor> fieldEditors = new ArrayList();
    private FieldEditor invalidFieldEditor = null;

    public ColorPreferences() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("YEdit Color Preferences for syntax highlighting");
    }

    protected void createFieldEditors(Composite parent) {
        this.addSyntaxCategory("colorCommentPreference", "boldCommentPreference", "italicCommentPreference", "underlineCommentPreference", "Comments", parent);
        this.addSyntaxCategory("colorKeyPreference", "boldKeyPreference", "italicKeyPreference", "underlineKeyPreference", "Keys", parent);
        this.addSyntaxCategory("colorScalarPreference", "boldScalarPreference", "italicScalarPreference", "underlineScalarPreference", "Scalars", parent);
        this.addSyntaxCategory("colorConstantPreferences", "boldConstantPreference", "italicConstantPreference", "underlineConstantPreference", "Constants", parent);
        this.addSyntaxCategory("colorAnchorPreferences", "boldAnchorPreference", "italicAnchorPreference", "underlineAnchorPreference", "Anchors", parent);
        this.addSyntaxCategory("colorAliasPreferences", "boldAliasPreference", "italicAliasPreference", "underlineAliasPreference", "Alias", parent);
        this.addSyntaxCategory("colorTagPropertyPreferences", "boldTagPropertyPreference", "italicTagPropertyPreference", "underlineTagPropertyPreference", "Tags", parent);
        this.addSyntaxCategory("colorDocumentPreference", "boldDocumentPreference", "italicDocumentPreference", "underlineDocumentPreference", "Documents", parent);
        this.addSyntaxCategory("colorDefaultPreference", "boldDefaultPreference", "italicDefaultPreference", "underlineDefaulPreference", "Default", parent);
    }

    private void addSyntaxCategory(String colorConstant, String boldConstant, String italicConstant, String underlineConstant, String labelText, Composite parent) {
        Label categoryLabel = new Label(parent, 16384);
        GridData gdLabel = new GridData();
        gdLabel.horizontalAlignment = 1;
        gdLabel.minimumWidth = 150;
        categoryLabel.setText(labelText);
        categoryLabel.setLayoutData((Object)gdLabel);
        Composite colorC = new Composite(parent, 16384);
        GridData gdColor = new GridData();
        gdColor.horizontalAlignment = 1;
        colorC.setLayoutData((Object)gdColor);
        ColorFieldEditor colorEditor = new ColorFieldEditor(colorConstant, "", colorC);
        this.fieldEditors.add((FieldEditor)colorEditor);
        Composite boldC = new Composite(parent, 16384);
        GridData gdBold = new GridData();
        boldC.setLayoutData((Object)gdBold);
        BooleanFieldEditor boldEditor = new BooleanFieldEditor(boldConstant, "Bold", boldC);
        this.fieldEditors.add((FieldEditor)boldEditor);
        Composite italicC = new Composite(parent, 16384);
        GridData gdItalic = new GridData();
        italicC.setLayoutData((Object)gdItalic);
        BooleanFieldEditor italicEditor = new BooleanFieldEditor(italicConstant, "Italic", italicC);
        this.fieldEditors.add((FieldEditor)italicEditor);
        Composite underlineC = new Composite(parent, 16384);
        GridData gdUnderline = new GridData();
        underlineC.setLayoutData((Object)gdUnderline);
        BooleanFieldEditor underlineEditor = new BooleanFieldEditor(underlineConstant, "Underline", underlineC);
        this.fieldEditors.add((FieldEditor)underlineEditor);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 5;
        c.setLayout((Layout)gl);
        this.createFieldEditors(c);
        this.initialize();
        this.checkState();
        return c;
    }

    protected void initialize() {
        for (FieldEditor pe : this.fieldEditors) {
            pe.setPage((DialogPage)this);
            pe.setPropertyChangeListener((IPropertyChangeListener)this);
            pe.setPreferenceStore(this.getPreferenceStore());
            pe.load();
        }
    }

    protected void performDefaults() {
        for (FieldEditor pe : this.fieldEditors) {
            pe.loadDefault();
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        for (FieldEditor pe : this.fieldEditors) {
            pe.store();
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.invalidFieldEditor = (FieldEditor)event.getSource();
                this.setValid(newValue);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.invalidFieldEditor != null) {
            this.invalidFieldEditor.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        for (FieldEditor pe : this.fieldEditors) {
            pe.setPage(null);
            pe.setPropertyChangeListener(null);
            pe.setPreferenceStore(null);
        }
    }

    protected void checkState() {
        boolean valid = true;
        this.invalidFieldEditor = null;
        for (FieldEditor editor : this.fieldEditors) {
            boolean bl = valid = valid && editor.isValid();
            if (valid) continue;
            this.invalidFieldEditor = editor;
            break;
        }
        this.setValid(valid);
    }
}

