/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.status;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;

public class StatusHandlerService {
    private static final String STATUS_HANDLER_EXTENSION_POINT_ID = "org.eclipse.ui.statusHandlers";
    private static final String STATUS_HANDLER_PRODUCT_BINDING = "statusHandlerProductBinding";
    private static final String PRODUCT_ID = "productId";
    private static final String PLATFORM_HANDLER_EXTENSION_POINT_ID = "org.eclipse.datatools.connectivity.ui.connectionExceptionHandler";
    private static final String HANDLER = "handler";
    private static final String VENDOR = "vendor";

    public static boolean doesDataToolsHandlerExist(IConnectionProfile profile) {
        return StatusHandlerService.doesHandlerExistForProduct() && StatusHandlerService.doesHandlerExistForPlatform(profile);
    }

    private static boolean doesHandlerExistForProduct() {
        boolean productMappingExists = false;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(STATUS_HANDLER_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            return productMappingExists;
        }
        int i = 0;
        block0: while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(STATUS_HANDLER_PRODUCT_BINDING)) {
                    String productID = elements[k].getAttribute(PRODUCT_ID);
                    IProduct product = Platform.getProduct();
                    if (product.getId().equals(productID)) {
                        productMappingExists = true;
                        break block0;
                    }
                }
                ++k;
            }
            ++i;
        }
        return productMappingExists;
    }

    private static boolean doesHandlerExistForPlatform(IConnectionProfile profile) {
        boolean exists = false;
        String vendor = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLATFORM_HANDLER_EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        block0: while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(HANDLER)) {
                    String extensionVendor = elements[j].getAttribute(VENDOR);
                    if (!extensionVendor.equalsIgnoreCase(vendor)) break;
                    exists = true;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return exists;
    }
}

