/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;

public class GenericRefactoringHandleTransplanter {
    public final IJavaElement transplantHandle(IJavaElement element) {
        IJavaElement parent = element.getParent();
        if (parent != null) {
            parent = this.transplantHandle(parent);
        }
        switch (element.getElementType()) {
            case 1: {
                return this.transplantHandle((IJavaModel)element);
            }
            case 2: {
                return this.transplantHandle((IJavaProject)element);
            }
            case 3: {
                return this.transplantHandle((IJavaProject)parent, (IPackageFragmentRoot)element);
            }
            case 4: {
                return this.transplantHandle((IPackageFragmentRoot)parent, (IPackageFragment)element);
            }
            case 5: {
                return this.transplantHandle((IPackageFragment)parent, (ICompilationUnit)element);
            }
            case 6: {
                return this.transplantHandle((IPackageFragment)parent, (IClassFile)element);
            }
            case 7: {
                return this.transplantHandle(parent, (IType)element);
            }
            case 8: {
                return this.transplantHandle((IType)parent, (IField)element);
            }
            case 9: {
                return this.transplantHandle((IType)parent, (IMethod)element);
            }
            case 10: {
                return this.transplantHandle((IType)parent, (IInitializer)element);
            }
            case 11: {
                return this.transplantHandle((ICompilationUnit)parent, (IPackageDeclaration)element);
            }
            case 12: {
                return this.transplantHandle((ICompilationUnit)parent, (IImportContainer)element);
            }
            case 13: {
                return this.transplantHandle((IImportContainer)parent, (IImportDeclaration)element);
            }
            case 14: {
                return this.transplantHandle((ILocalVariable)element);
            }
            case 15: {
                return this.transplantHandle((IMember)parent, (ITypeParameter)element);
            }
            case 16: {
                return this.transplantHandle((IAnnotatable)parent, (IAnnotation)element);
            }
        }
        throw new IllegalArgumentException(element.toString());
    }

    protected IJavaModel transplantHandle(IJavaModel element) {
        return element;
    }

    protected IJavaProject transplantHandle(IJavaProject element) {
        return element;
    }

    protected IPackageFragmentRoot transplantHandle(IJavaProject parent, IPackageFragmentRoot element) {
        return element;
    }

    protected IPackageFragment transplantHandle(IPackageFragmentRoot parent, IPackageFragment element) {
        return parent.getPackageFragment(element.getElementName());
    }

    protected ICompilationUnit transplantHandle(IPackageFragment parent, ICompilationUnit element) {
        return parent.getCompilationUnit(element.getElementName());
    }

    protected IClassFile transplantHandle(IPackageFragment parent, IClassFile element) {
        return parent.getClassFile(element.getElementName());
    }

    protected IType transplantHandle(IJavaElement parent, IType element) {
        switch (parent.getElementType()) {
            case 5: {
                return ((ICompilationUnit)parent).getType(element.getElementName());
            }
            case 6: {
                if (parent instanceof IOrdinaryClassFile) {
                    return ((IOrdinaryClassFile)parent).getType();
                }
                throw new IllegalStateException(element.toString());
            }
            case 9: {
                return ((IMethod)parent).getType(element.getElementName(), element.getOccurrenceCount());
            }
            case 8: {
                return ((IField)parent).getType(element.getElementName(), element.getOccurrenceCount());
            }
            case 10: {
                return ((IInitializer)parent).getType(element.getElementName(), element.getOccurrenceCount());
            }
            case 7: {
                return ((IType)parent).getType(element.getElementName(), element.getOccurrenceCount());
            }
        }
        throw new IllegalStateException(element.toString());
    }

    protected IField transplantHandle(IType parent, IField element) {
        return parent.getField(element.getElementName());
    }

    protected IMethod transplantHandle(IType parent, IMethod element) {
        return parent.getMethod(element.getElementName(), element.getParameterTypes());
    }

    protected IInitializer transplantHandle(IType parent, IInitializer element) {
        return parent.getInitializer(element.getOccurrenceCount());
    }

    protected IPackageDeclaration transplantHandle(ICompilationUnit parent, IPackageDeclaration element) {
        return parent.getPackageDeclaration(element.getElementName());
    }

    protected IImportContainer transplantHandle(ICompilationUnit parent, IImportContainer element) {
        return parent.getImportContainer();
    }

    protected IImportDeclaration transplantHandle(IImportContainer parent, IImportDeclaration element) {
        return parent.getImport(element.getElementName());
    }

    protected ILocalVariable transplantHandle(ILocalVariable element) {
        return element;
    }

    protected IAnnotation transplantHandle(IAnnotatable parent, IAnnotation element) {
        return parent.getAnnotation(element.getElementName());
    }

    protected ITypeParameter transplantHandle(IMember parent, ITypeParameter element) {
        switch (parent.getElementType()) {
            case 7: {
                return ((IType)parent).getTypeParameter(element.getElementName());
            }
            case 9: {
                return ((IMethod)parent).getTypeParameter(element.getElementName());
            }
        }
        throw new IllegalStateException(element.toString());
    }
}

