/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.ui.wizards.JavadocExportWizardPage;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.w3c.dom.Element;

public class ContributedJavadocWizardPage
extends NewElementWizardPage
implements JavadocExportWizardPage.IJavadocExportWizardPageContainer {
    private static final String ATT_EXTENSION = "javadocExportWizardPage";
    private static final String ATT_ID = "id";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_PAGE_CLASS = "class";
    private IConfigurationElement fConfigElement;
    private JavadocExportWizardPage fPage;
    private final JavadocOptionsManager fStore;

    public ContributedJavadocWizardPage(IConfigurationElement configElement, JavadocOptionsManager store) {
        super(configElement.getAttribute(ATT_ID));
        this.fConfigElement = configElement;
        this.fStore = store;
        this.fPage = null;
        this.setTitle(JavadocExportMessages.JavadocWizardPage_javadocwizardpage_description);
        this.setDescription(this.fConfigElement.getAttribute(ATT_DESCRIPTION));
    }

    public void createControl(Composite parent) {
        Control createContents = this.getPage().createContents(parent);
        this.setControl(createContents);
    }

    @Override
    public void setVisible(boolean visible) {
        this.getPage().setVisible(visible);
        super.setVisible(visible);
    }

    @Override
    public IRunnableContext getRunnableContext() {
        return this.getContainer();
    }

    @Override
    public void statusUpdated() {
        this.updateStatus(this.getPage().getStatus());
    }

    public void performHelp() {
        this.getPage().performHelp();
    }

    public void dispose() {
        if (this.fPage != null) {
            this.fPage.dispose();
            this.fPage = null;
        }
        super.dispose();
    }

    @Override
    public String[] getConfiguredJavadocOptions() {
        ArrayList<String> vmArgs = new ArrayList<String>();
        ArrayList<String> toolArgs = new ArrayList<String>();
        this.fStore.getArgumentArray(vmArgs, toolArgs);
        return toolArgs.toArray(new String[toolArgs.size()]);
    }

    @Override
    public String[] getConfiguredVMOptions() {
        ArrayList<String> vmArgs = new ArrayList<String>();
        ArrayList<String> toolArgs = new ArrayList<String>();
        this.fStore.getArgumentArray(vmArgs, toolArgs);
        return vmArgs.toArray(new String[vmArgs.size()]);
    }

    @Override
    public IJavaElement[] getSelectedJavaElements() {
        IJavaElement[] sourceElements = this.fStore.getSourceElements();
        if (sourceElements != null) {
            return (IJavaElement[])sourceElements.clone();
        }
        return new IJavaElement[0];
    }

    public void updateArguments(ArrayList<String> vmOptions, ArrayList<String> toolOptions) {
        this.getPage().updateArguments(vmOptions, toolOptions);
    }

    public void updateAntScript(Element xmlDocument) {
        this.getPage().updateAntScript(xmlDocument);
    }

    private JavadocExportWizardPage getPage() {
        if (this.fPage == null) {
            try {
                Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
                if (elem instanceof JavadocExportWizardPage) {
                    this.fPage = (JavadocExportWizardPage)elem;
                    this.fPage.setContainer(this);
                    this.statusUpdated();
                    return this.fPage;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            this.fPage = new ErrorJavadocExportWizardPage();
        }
        return this.fPage;
    }

    public static ContributedJavadocWizardPage[] getContributedPages(JavadocOptionsManager store) {
        ArrayList<ContributedJavadocWizardPage> pages = new ArrayList<ContributedJavadocWizardPage>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui", ATT_EXTENSION);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement curr = elements[i];
            String id = curr.getAttribute(ATT_ID);
            String description = curr.getAttribute(ATT_DESCRIPTION);
            String pageClassName = curr.getAttribute(ATT_PAGE_CLASS);
            if (id == null || description == null || pageClassName == null) {
                JavaPlugin.logErrorMessage("Invalid extension " + curr.toString());
            } else {
                pages.add(new ContributedJavadocWizardPage(elements[i], store));
            }
            ++i;
        }
        return pages.toArray(new ContributedJavadocWizardPage[pages.size()]);
    }

    private static class ErrorJavadocExportWizardPage
    extends JavadocExportWizardPage {
        private ErrorJavadocExportWizardPage() {
        }

        @Override
        public Control createContents(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(JavadocExportMessages.ContributedJavadocWizardPage_error_create_page);
            return label;
        }
    }
}

