/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnumMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaEnumMapping
extends AbstractJavaTypeMapping
implements JavaEnumMapping {
    protected String value;
    protected String specifiedValue;
    protected final EnumConstantContainer enumConstantContainer = new EnumConstantContainer();

    public GenericJavaEnumMapping(JavaEnum parent) {
        super(parent);
        this.initValue();
        this.initEnumConstants();
    }

    public JavaResourceEnum getJavaResourceType() {
        return (JavaResourceEnum)super.getJavaResourceType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncValue();
        this.syncEnumConstants();
    }

    @Override
    public void update() {
        super.update();
        this.updateEnumConstants();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    @Override
    public String getSpecifiedValue() {
        return this.specifiedValue;
    }

    @Override
    public void setSpecifiedValue(String value) {
        this.getXmlEnumAnnotation().setValue(value);
        this.setSpecifiedValue_(value);
    }

    protected void setSpecifiedValue_(String value) {
        String old = this.specifiedValue;
        this.specifiedValue = value;
        this.firePropertyChanged("specifiedXmlEnum", old, value);
    }

    protected XmlEnumAnnotation getXmlEnumAnnotation() {
        return (XmlEnumAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlEnum");
    }

    protected String getResourceValue() {
        return this.getXmlEnumAnnotation().getValue();
    }

    protected void initValue() {
        String value = this.getXmlEnumAnnotation().getFullyQualifiedValueClassName();
        if (value == null) {
            value = "java.lang.String";
        }
        this.value = value;
        this.specifiedValue = this.getResourceValue();
    }

    protected void syncValue() {
        String value = this.getXmlEnumAnnotation().getFullyQualifiedValueClassName();
        if (value == null) {
            value = "java.lang.String";
        }
        this.setValue_(value);
        this.setSpecifiedValue_(this.getResourceValue());
    }

    @Override
    public Iterable<JaxbEnumConstant> getEnumConstants() {
        return IterableTools.cast(this.enumConstantContainer.getContextElements());
    }

    @Override
    public int getEnumConstantsSize() {
        return this.enumConstantContainer.getContextElementsSize();
    }

    protected void initEnumConstants() {
        this.enumConstantContainer.initialize();
    }

    protected void syncEnumConstants() {
        this.enumConstantContainer.synchronizeWithResourceModel();
    }

    protected void updateEnumConstants() {
        this.enumConstantContainer.update();
    }

    protected Iterable<JavaResourceEnumConstant> getResourceEnumConstants() {
        return this.getJavaResourceType().getEnumConstants();
    }

    private JaxbEnumConstant buildEnumConstant(JavaResourceEnumConstant resourceEnumConstant) {
        return this.getFactory().buildJavaEnumConstant(this, resourceEnumConstant);
    }

    @Override
    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        if (this.specifiedValue != null) {
            return IterableTools.concatenate((Iterable[])new Iterable[]{super.getNonTransientReferencedXmlTypeNames(), IterableTools.singletonIterable((Object)this.getValue())});
        }
        return super.getNonTransientReferencedXmlTypeNames();
    }

    @Override
    public XsdSimpleTypeDefinition getValueXsdTypeDefinition() {
        XsdTypeDefinition xsdType = this.getValueXsdTypeDefinition_();
        if (xsdType == null || xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            return null;
        }
        return (XsdSimpleTypeDefinition)xsdType;
    }

    protected XsdTypeDefinition getValueXsdTypeDefinition_() {
        String fqXmlEnumValue = this.getValue();
        JavaType jaxbType = this.getContextRoot().getJavaType(fqXmlEnumValue);
        if (jaxbType != null) {
            JavaTypeMapping typeMapping = jaxbType.getMapping();
            if (typeMapping != null) {
                return typeMapping.getXsdTypeDefinition();
            }
        } else {
            String typeMapping = this.getJaxbProject().getPlatform().getDefinition().getSchemaTypeMapping(fqXmlEnumValue);
            if (typeMapping != null) {
                XsdSchema xsdSchema = XsdUtil.getSchemaForSchema();
                return xsdSchema.getTypeDefinition(typeMapping);
            }
        }
        return null;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        for (JaxbEnumConstant constant : this.getEnumConstants()) {
            result = constant.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateXmlType(messages, reporter);
        this.validateXmlEnum(messages, reporter);
        for (JaxbEnumConstant constant : this.getEnumConstants()) {
            constant.validate(messages, reporter);
        }
    }

    protected void validateXmlType(List<IMessage> messages, IReporter reporter) {
        XmlTypeAnnotation annotation = this.getXmlTypeAnnotation();
        if (annotation.getFactoryClass() != null) {
            messages.add(this.buildValidationMessage(annotation.getFactoryClassTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__FACTORY_CLASS_IGNORED_FOR_ENUM));
        }
        if (annotation.getFactoryMethod() != null) {
            messages.add(this.buildValidationMessage(annotation.getFactoryMethodTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__FACTORY_METHOD_IGNORED_FOR_ENUM));
        }
        if (!IterableTools.isEmpty(annotation.getPropOrder())) {
            messages.add(this.buildValidationMessage(annotation.getPropOrderTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__PROP_ORDER_IGNORED_FOR_ENUM));
        }
    }

    protected void validateXmlEnum(List<IMessage> messages, IReporter reporter) {
        XsdSchema xsdSchema = this.getJaxbPackage().getXsdSchema();
        XsdTypeDefinition xsdType = this.getValueXsdTypeDefinition_();
        if (xsdSchema != null && xsdType == null || xsdType != null && xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            messages.add(this.buildValidationMessage(this.getXmlEnumValueTextRange(), JptJaxbCoreValidationMessages.XML_ENUM__NON_SIMPLE_SCHEMA_TYPE, this.getValue()));
        }
    }

    protected TextRange getXmlEnumValueTextRange() {
        return this.getXmlEnumAnnotation().getValueTextRange();
    }

    protected class EnumConstantContainer
    extends AbstractJaxbNode.ContextCollectionContainer<JaxbEnumConstant, JavaResourceEnumConstant> {
        protected EnumConstantContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "enumConstants";
        }

        @Override
        protected JaxbEnumConstant buildContextElement(JavaResourceEnumConstant resourceElement) {
            return GenericJavaEnumMapping.this.buildEnumConstant(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceEnumConstant> getResourceElements() {
            return GenericJavaEnumMapping.this.getResourceEnumConstants();
        }

        @Override
        protected JavaResourceEnumConstant getResourceElement(JaxbEnumConstant contextElement) {
            return contextElement.getResourceEnumConstant();
        }
    }
}

