/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.RunImageCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RunDockerImageLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private static final String LaunchShortcut_Connection_Selection = "ImageBuildShortcutConnectionSelection.title";
    private static final String LaunchShortcut_Choose_Connection = "ImageBuildShortcutChooseConnection.msg";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        try {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            IDockerContainerConfig containerConfig = this.getDockerContainerConfig(config);
            IDockerHostConfig hostConfig = this.getDockerHostConfig(config);
            IDockerConnection connection = this.getDockerConnection(config);
            if (connection == null) {
                return;
            }
            IDockerImage image = this.getDockerImage(config, connection);
            RunImageCommandHandler.runImage(image, containerConfig, hostConfig, config.getAttribute("containerName", null), config.getAttribute("autoRemove", false));
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private IDockerImage getDockerImage(ILaunchConfiguration config, IDockerConnection connection) throws CoreException {
        String imageId = config.getAttribute("imageId", null);
        if (imageId != null) {
            return ((DockerConnection)connection).getImage(imageId);
        }
        return null;
    }

    public IDockerHostConfig getDockerHostConfig(ILaunchConfiguration config) throws CoreException {
        DockerHostConfig.Builder hostConfigBuilder = new DockerHostConfig.Builder();
        if (config.getAttribute("publishAllPorts", false)) {
            hostConfigBuilder.publishAllPorts(Boolean.valueOf(true));
        } else {
            List serializedBindings = config.getAttribute("publishedPorts", new ArrayList());
            Map<String, List<IDockerPortBinding>> portBindings = LaunchConfigurationUtils.deserializePortBindings(serializedBindings);
            hostConfigBuilder.portBindings(portBindings);
        }
        List links = config.getAttribute("links", new ArrayList());
        hostConfigBuilder.links(links);
        List volumesFromList = config.getAttribute("volumesFrom", new ArrayList());
        hostConfigBuilder.volumesFrom(volumesFromList);
        ArrayList<String> binds = new ArrayList<String>();
        List bindsList = config.getAttribute("binds", new ArrayList());
        for (String bindsListEntry : bindsList) {
            String[] bindsEntryParms = bindsListEntry.split(":");
            StringBuilder bind = new StringBuilder();
            bind.append(LaunchConfigurationUtils.convertToUnixPath(bindsEntryParms[0])).append(':').append(bindsEntryParms[1]).append(":Z");
            if (bindsEntryParms[2].equals("true")) {
                bind.append(",ro");
            }
            binds.add(bind.toString());
        }
        hostConfigBuilder.binds(binds);
        boolean privileged = config.getAttribute("privileged", false);
        hostConfigBuilder.privileged(Boolean.valueOf(privileged));
        boolean readonly = config.getAttribute("readonly", false);
        hostConfigBuilder.readonlyRootfs(Boolean.valueOf(readonly));
        String networkMode = config.getAttribute("networkMode", "");
        if (!networkMode.isEmpty()) {
            hostConfigBuilder.networkMode(networkMode);
        }
        return hostConfigBuilder.build();
    }

    public IDockerContainerConfig getDockerContainerConfig(ILaunchConfiguration lconfig) throws CoreException {
        String command = lconfig.getAttribute("command", "");
        String entrypoint = lconfig.getAttribute("entryPoint", "");
        String imageName = lconfig.getAttribute("imageName", "");
        boolean useTTY = lconfig.getAttribute("allocatePseudoTTY", false);
        boolean interactive = lconfig.getAttribute("interactive", false);
        DockerContainerConfig.Builder config = new DockerContainerConfig.Builder().cmd(command).entryPoint(entrypoint).image(imageName).tty(Boolean.valueOf(useTTY)).openStdin(Boolean.valueOf(interactive));
        boolean limits_enabled = lconfig.getAttribute("enableLimits", false);
        if (limits_enabled) {
            long memory = Long.parseLong(lconfig.getAttribute("memoryLimit", "0"));
            config.memory(Long.valueOf(memory));
            long cpuShares = Long.parseLong(lconfig.getAttribute("cpuPriority", "0"));
            config.cpuShares(Long.valueOf(cpuShares));
        }
        List environmentVariables = lconfig.getAttribute("envVariables", new ArrayList());
        config.env(environmentVariables);
        Map labelVariables = lconfig.getAttribute("labels", null);
        if (labelVariables != null) {
            config.labels(labelVariables);
        }
        return config.build();
    }

    private IDockerConnection getDockerConnection(ILaunchConfiguration config) throws CoreException {
        String configName = config.getAttribute("connectionName", "");
        IDockerConnection connection = DockerConnectionManager.getInstance().findConnection(configName);
        if (connection == null) {
            connection = this.chooseConnection(DockerConnectionManager.getInstance().getConnections());
        }
        return connection;
    }

    protected IDockerConnection chooseConnection(IDockerConnection[] connections) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)new ConnectionSelectionLabelProvider(this){});
        dialog.setElements((Object[])connections);
        dialog.setTitle(LaunchMessages.getString(LaunchShortcut_Connection_Selection));
        dialog.setMessage(LaunchMessages.getString(LaunchShortcut_Choose_Connection));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (IDockerConnection)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return Activator.getActiveWorkbenchShell();
    }

    private class ConnectionSelectionLabelProvider
    implements ILabelProvider {
        private Image CONNECTION_IMAGE = SWTImagesFactory.DESC_REPOSITORY_MIDDLE.createImage();

        private ConnectionSelectionLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            this.CONNECTION_IMAGE.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return this.CONNECTION_IMAGE;
        }
    }
}

