/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.features.custom.CollapseFeature;
import org.fusesource.ide.camel.editor.features.custom.LayoutDiagramFeature;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class LayoutCommand
extends RecordingCommand {
    private final IFeatureProvider featureProvider;
    private AbstractCamelModelElement container;
    private PictogramElement diagram;

    public LayoutCommand(IFeatureProvider featureProvider, Diagram diagram, AbstractCamelModelElement container, TransactionalEditingDomain editingDomain) {
        super(editingDomain);
        this.featureProvider = featureProvider;
        this.container = container;
        this.diagram = diagram;
    }

    protected void doExecute() {
        this.layout(this.featureProvider, this.container);
        if (this.container instanceof CamelRouteContainerElement) {
            this.layout(this.featureProvider, this.diagram);
        }
    }

    private void layout(IFeatureProvider featureProvider, AbstractCamelModelElement container) {
        if (container == null) {
            return;
        }
        if (!CollapseFeature.isCollapsed(featureProvider, container)) {
            for (AbstractCamelModelElement cme : container.getChildElements()) {
                this.layout(featureProvider, cme);
            }
        }
        if (container instanceof CamelRouteElement || container.getUnderlyingMetaModelObject() != null && container.getUnderlyingMetaModelObject().canHaveChildren()) {
            this.layout(featureProvider, featureProvider.getPictogramElementForBusinessObject((Object)container));
        }
    }

    private void layout(IFeatureProvider featureProvider, PictogramElement pe) {
        ICustomFeature[] cfs;
        if (CollapseFeature.isCollapsed(pe)) {
            return;
        }
        CustomContext cc = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] iCustomFeatureArray = cfs = featureProvider.getCustomFeatures(null);
        int n = cfs.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature cf = iCustomFeatureArray[n2];
            if (cf instanceof LayoutDiagramFeature) {
                cf.execute((ICustomContext)cc);
                break;
            }
            ++n2;
        }
    }
}

