/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.component.wizard;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;

public class ComponentManager {
    private Map<String, Set<Component>> tagMap = new HashMap<String, Set<Component>>();
    private Set<Component> noTagComponents = new HashSet<Component>();
    private CamelModel model;

    public ComponentManager(CamelModel model) {
        this.model = model;
        this.initTagMap(model);
    }

    private void initTagMap(CamelModel model) {
        for (Component component : model.getComponents()) {
            List componentTags = component.getTags();
            if (componentTags == null || componentTags.isEmpty()) {
                this.noTagComponents.add(component);
                continue;
            }
            for (String tag : componentTags) {
                Set<Component> componentsForTag = this.tagMap.get(tag);
                if (componentsForTag != null) {
                    componentsForTag.add(component);
                    continue;
                }
                HashSet<Component> set = new HashSet<Component>();
                set.add(component);
                this.tagMap.put(tag, set);
            }
        }
    }

    public Set<Component> getComponentForTag(String tag) {
        Set<Component> componentSet = this.tagMap.get(tag);
        return componentSet != null ? componentSet : Collections.emptySet();
    }

    public Set<Component> getComponentWithoutTag() {
        return this.noTagComponents;
    }

    public Set<String> getTags() {
        return this.tagMap.keySet();
    }

    public Set<Component> getAllComponents() {
        return new HashSet<Component>(this.model.getComponents());
    }
}

