/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.component.wizard;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.camel.editor.component.wizard.ComponentGroupedByTagsTreeContenProvider;
import org.fusesource.ide.camel.editor.component.wizard.ComponentLabelProvider;
import org.fusesource.ide.camel.editor.component.wizard.ComponentListTreeContentProvider;
import org.fusesource.ide.camel.editor.component.wizard.ComponentManager;
import org.fusesource.ide.camel.editor.component.wizard.ComponentNameAndTagPatternFilter;
import org.fusesource.ide.camel.editor.component.wizard.NewEndpointIdValidator;
import org.fusesource.ide.camel.editor.component.wizard.WhiteListComponentFilter;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class SelectComponentWizardPage
extends WizardPage {
    private CamelModel model;
    private DataBindingContext dbc;
    private Component componentSelected;
    private String id;
    private AbstractCamelModelElement parent;

    public SelectComponentWizardPage(DataBindingContext dbc, CamelModel model, String title, String description, AbstractCamelModelElement parent) {
        super(UIMessages.selectComponentWizardPagePageName);
        this.setTitle(title);
        this.setDescription(description);
        this.dbc = dbc;
        this.model = model;
        this.parent = parent;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.createIdLine(composite);
        this.createCamelComponentSelectionGroup(composite);
        this.setControl((Control)composite);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
    }

    private void createIdLine(Composite composite) {
        Label idLabel = new Label(composite, 0);
        idLabel.setText(UIMessages.globalEndpointWizardPageIdFieldLabel);
        Text idText = new Text(composite, 2048);
        idText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).create());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)new NewEndpointIdValidator(this.parent));
        IObservableValue idObservable = PojoProperties.value(SelectComponentWizardPage.class, (String)"id", String.class).observe((Object)this);
        Binding binding = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)idText), idObservable, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
    }

    private void createCamelComponentSelectionGroup(Composite parent) {
        Group componentSelectionGroup = new Group(parent, 0);
        componentSelectionGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        componentSelectionGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        componentSelectionGroup.setText(UIMessages.globalEndpointWizardPageComponentSelectionGroupTitle);
        FilteredTree filteredTree = this.createFilteredTree(componentSelectionGroup);
        this.createCheckboxFilterComposite(componentSelectionGroup, filteredTree.getViewer());
    }

    private FilteredTree createFilteredTree(Group componentSelectionGroup) {
        FilteredTree filteredTree = new FilteredTree((Composite)componentSelectionGroup, 2820, (PatternFilter)new ComponentNameAndTagPatternFilter(), true);
        filteredTree.getFilterControl().setMessage(UIMessages.globalEndpointWizardPageFilterSearchMessage);
        int xHint = this.getShell().getSize().x - 20;
        filteredTree.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).hint(xHint, 400).create());
        TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new ComponentListTreeContentProvider());
        treeViewer.setComparator(new ViewerComparator());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        treeViewer.setInput((Object)new ComponentManager(this.model));
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof Component) {
                    return Status.OK_STATUS;
                }
                return ValidationStatus.error((String)UIMessages.globalEndpointWizardPageComponentSelectionMandatoryMessage);
            }
        });
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)treeViewer), PojoProperties.value(SelectComponentWizardPage.class, (String)"componentSelected", Component.class).observe((Object)this), strategy, null);
        return filteredTree;
    }

    private void createCheckboxFilterComposite(Group componentSelectionGroup, TreeViewer treeViewer) {
        Composite buttonsComposite = new Composite((Composite)componentSelectionGroup, 0);
        buttonsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.createCheckboxToGroupByCategory(buttonsComposite, treeViewer);
        this.createCheckboxToShowOnlyPaletteComponents(buttonsComposite, treeViewer);
    }

    private Button createCheckboxToShowOnlyPaletteComponents(Composite parent, final TreeViewer treeViewer) {
        final Button showOnlyPaletteComponents = new Button(parent, 32);
        showOnlyPaletteComponents.setText(UIMessages.globalEndpointWizardPageShowOnlyPaletteComonentsChecboxText);
        final WhiteListComponentFilter whiteListComponentFilter = new WhiteListComponentFilter();
        treeViewer.addFilter((ViewerFilter)whiteListComponentFilter);
        showOnlyPaletteComponents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (showOnlyPaletteComponents.getSelection()) {
                    treeViewer.addFilter((ViewerFilter)whiteListComponentFilter);
                } else {
                    treeViewer.removeFilter((ViewerFilter)whiteListComponentFilter);
                }
            }
        });
        showOnlyPaletteComponents.setSelection(true);
        return showOnlyPaletteComponents;
    }

    private Button createCheckboxToGroupByCategory(Composite parent, final TreeViewer treeViewer) {
        final Button groupedByCategories = new Button(parent, 32);
        groupedByCategories.setText(UIMessages.globalEndpointWizardPageGroupByCategories);
        groupedByCategories.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (groupedByCategories.getSelection()) {
                    treeViewer.setContentProvider((IContentProvider)new ComponentGroupedByTagsTreeContenProvider());
                } else {
                    treeViewer.setContentProvider((IContentProvider)new ComponentListTreeContentProvider());
                }
            }
        });
        return groupedByCategories;
    }

    public Component getComponentSelected() {
        return this.componentSelected;
    }

    public void setComponentSelected(Component componentSelected) {
        this.componentSelected = componentSelected;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

