/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class CollapseFeature
extends AbstractCustomFeature {
    public static final String PROP_COLLAPSED_STATE = "isCollapsed";
    public static final String PROP_EXPANDED_WIDTH = "expandedWidth";
    public static final String PROP_EXPANDED_HEIGHT = "expandedHeight";
    public static final String PROP_COLLAPSED_WIDTH = "collapsedWidth";
    public static final String PROP_COLLAPSED_HEIGHT = "collapsedHeight";
    private PictogramElement lastPE;

    public CollapseFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AbstractCamelModelElement) {
            return !((AbstractCamelModelElement)bo).getChildElements().isEmpty();
        }
        return ret;
    }

    public boolean isAvailable(IContext context) {
        if (context instanceof ICustomContext) {
            this.lastPE = ((ICustomContext)context).getPictogramElements()[0];
        }
        return super.isAvailable(context);
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AbstractCamelModelElement) {
            this.collapseShape(pes[0]);
        }
        ((CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer()).autoLayoutRoute();
        this.getDiagramBehavior().getDiagramContainer().selectPictogramElements(pes);
    }

    public String getName() {
        return this.isCollapsed() ? "Expand" : "Collapse";
    }

    public String getDescription() {
        return String.format("%s the selected node...", this.isCollapsed() ? "Expands" : "Collapses");
    }

    private boolean isCollapsed() {
        return Graphiti.getPeService().getPropertyValue((PropertyContainer)this.lastPE, PROP_COLLAPSED_STATE) != null && !Graphiti.getPeService().getPropertyValue((PropertyContainer)this.lastPE, PROP_COLLAPSED_STATE).equals("false");
    }

    public void collapseShape(PictogramElement pe) {
        ContainerShape cs = (ContainerShape)pe;
        int changeWidth = 0;
        int changeHeight = 0;
        boolean childFiguresVisible = false;
        String initialCollapsedState = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, PROP_COLLAPSED_STATE);
        if (initialCollapsedState == null || initialCollapsedState.equals("false")) {
            int width = pe.getGraphicsAlgorithm().getWidth();
            int height = pe.getGraphicsAlgorithm().getHeight();
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, PROP_EXPANDED_WIDTH, String.valueOf(width));
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, PROP_EXPANDED_HEIGHT, String.valueOf(height));
        } else if (initialCollapsedState.equals("true")) {
            changeWidth = Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, PROP_EXPANDED_WIDTH));
            changeHeight = Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, PROP_EXPANDED_HEIGHT));
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, PROP_COLLAPSED_STATE, "false");
            childFiguresVisible = true;
        }
        if (!childFiguresVisible) {
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, PROP_COLLAPSED_STATE, "true");
        }
        this.makeChildrenInvisible(cs, childFiguresVisible);
        this.updateBorderStyle(cs, !childFiguresVisible);
        ResizeShapeContext context1 = new ResizeShapeContext((Shape)cs);
        context1.setSize(changeWidth, changeHeight);
        context1.setLocation(cs.getGraphicsAlgorithm().getX(), cs.getGraphicsAlgorithm().getY());
        IResizeShapeFeature rsf = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)context1);
        if (rsf.canExecute((IContext)context1)) {
            rsf.execute((IContext)context1);
        }
    }

    public void updateBorderStyle(ContainerShape cs, boolean collapsed) {
        IGaService gaService = Graphiti.getGaService();
        Color col = collapsed ? gaService.manageColor(this.getDiagram(), StyleUtil.CONTAINER_FIGURE_COLLAPSED_BORDER_COLOR) : gaService.manageColor(this.getDiagram(), StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        GraphicsAlgorithm ga = cs.getGraphicsAlgorithm();
        ga.setLineStyle(collapsed ? LineStyle.DASH : LineStyle.SOLID);
        ga.setForeground(col);
    }

    public void makeChildrenInvisible(ContainerShape cs, boolean visible) {
        if (cs.getChildren().isEmpty()) {
            return;
        }
        for (Shape shape : cs.getChildren()) {
            int j;
            Connection conn;
            if (!(shape instanceof ContainerShape)) continue;
            ContainerShape tmpCS = (ContainerShape)shape;
            if (Graphiti.getPeService().getPropertyValue((PropertyContainer)tmpCS, PROP_COLLAPSED_STATE) == null || Graphiti.getPeService().getPropertyValue((PropertyContainer)tmpCS, PROP_COLLAPSED_STATE).equals("false")) {
                this.makeChildrenInvisible((ContainerShape)shape, visible);
            }
            shape.setVisible(visible);
            Anchor anchr = (Anchor)shape.getAnchors().get(0);
            boolean initVisible = false;
            for (Shape shape1 : ((ContainerShape)shape).getChildren()) {
                if (!(shape1.getGraphicsAlgorithm() instanceof Ellipse)) continue;
                initVisible = shape1.isVisible();
            }
            int i = 0;
            while (i < anchr.getIncomingConnections().size()) {
                conn = (Connection)anchr.getIncomingConnections().get(i);
                if (initVisible) {
                    conn.setVisible(visible);
                    j = 0;
                    while (j < conn.getConnectionDecorators().size()) {
                        ((ConnectionDecorator)conn.getConnectionDecorators().get(j)).setVisible(visible);
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < anchr.getOutgoingConnections().size()) {
                conn = (Connection)anchr.getOutgoingConnections().get(i);
                conn.setVisible(visible);
                j = 0;
                while (j < conn.getConnectionDecorators().size()) {
                    ((ConnectionDecorator)conn.getConnectionDecorators().get(j)).setVisible(visible);
                    ++j;
                }
                ++i;
            }
        }
    }

    public static boolean isCollapsed(IFeatureProvider featureProvider, AbstractCamelModelElement container) {
        PictogramElement pe = featureProvider.getPictogramElementForBusinessObject((Object)container);
        return CollapseFeature.isCollapsed(pe);
    }

    public static boolean isCollapsed(PictogramElement pe) {
        if (pe != null) {
            return "true".equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, PROP_COLLAPSED_STATE));
        }
        return false;
    }
}

