/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class DisableCamelBreakpointFeature
extends SetEndpointBreakpointFeature {
    public DisableCamelBreakpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void execute(ICustomContext context) {
        PictogramElement _pe = this.getPEFromContext(context);
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            try {
                IFile contextFile = this.getContextFile();
                String fileName = contextFile.getName();
                String projectName = contextFile.getProject().getName();
                IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
                if (bp != null && bp.isEnabled()) {
                    bp.setEnabled(false);
                }
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof CamelDesignEditor ? ((CamelDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error on enabling breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    @Override
    public String getName() {
        return "Disable Breakpoint";
    }

    @Override
    public String getDescription() {
        return "Disables the breakpoint on the selected endpoint node";
    }

    @Override
    public String getImageId() {
        return "org.fusesource.ide.icons.graydot";
    }

    @Override
    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        PictogramElement _pe = this.getPEFromContext(cc);
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            if (_ep.supportsBreakpoint()) {
                IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
                try {
                    return bp != null && bp.isEnabled();
                }
                catch (CoreException ex) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
                }
            }
        }
        return false;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    @Override
    public boolean hasDoneChanges() {
        return false;
    }
}

