/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.dialogs.ConditionalBreakpointEditorDialog;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class SetConditionalBreakpointFeature
extends SetEndpointBreakpointFeature {
    public SetConditionalBreakpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void execute(ICustomContext context) {
        PictogramElement _pe = this.getPEFromContext(context);
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        IResource resource = this.getResource();
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            try {
                Boolean userWantsUpdate = null;
                IFile contextFile = this.getContextFile();
                String fileName = contextFile.getName();
                String projectName = contextFile.getProject().getName();
                ConditionalBreakpointEditorDialog dlg = new ConditionalBreakpointEditorDialog(Display.getDefault().getActiveShell(), _ep);
                dlg.setBlockOnOpen(true);
                if (dlg.open() == 0) {
                    String language = dlg.getLanguage();
                    String condition = dlg.getCondition();
                    if ((Strings.isBlank((String)_ep.getRouteContainer().getId()) || Strings.isBlank((String)_ep.getId())) && (userWantsUpdate = Boolean.valueOf(this.askForIDUpdate(_ep))).booleanValue()) {
                        if (Strings.isBlank((String)_ep.getRouteContainer().getId())) {
                            String newContextId = "context-" + UUID.randomUUID().toString();
                            _ep.getRouteContainer().setId(newContextId);
                        }
                        boolean foundUniqueId = false;
                        if (Strings.isBlank((String)_ep.getId())) {
                            String newNodeId = null;
                            while (!foundUniqueId) {
                                newNodeId = "_" + _ep.getNewID();
                                if (((CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer()).getModel().findNode(newNodeId) != null) continue;
                                foundUniqueId = true;
                            }
                            if (!Strings.isBlank(newNodeId)) {
                                _ep.setId(newNodeId);
                            } else {
                                throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.camel.editor", "Unable to determine a unique ID for node " + _ep));
                            }
                        }
                        this.saveEditor();
                    }
                    if (userWantsUpdate == null || userWantsUpdate.booleanValue()) {
                        CamelDebugUtils.createAndRegisterConditionalBreakpoint((IResource)resource, (AbstractCamelModelElement)_ep, (String)projectName, (String)fileName, (String)language, (String)condition);
                    }
                }
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof CamelDesignEditor ? ((CamelDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error on adding breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    @Override
    public String getName() {
        return "Set Conditional Breakpoint";
    }

    @Override
    public String getDescription() {
        return "Sets a conditional breakpoint on the selected endpoint node";
    }

    @Override
    public String getImageId() {
        return "org.fusesource.ide.icons.yellowdot";
    }

    @Override
    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        PictogramElement _pe = this.getPEFromContext(cc);
        Object bo = this.getBusinessObjectForPictogramElement(_pe);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement _ep = (AbstractCamelModelElement)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            return _ep.supportsBreakpoint() && CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName) == null;
        }
        return false;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }
}

