/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.BendPoint;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.fusesource.ide.camel.editor.features.custom.ZestLayoutAlgorithmnChoiceDialog;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;

public class ZestLayoutDiagramFeature
extends AbstractCustomFeature {
    static List<String> layouts = Arrays.asList("Spring Layout", "Tree Layout", "Grid Layout", "Horizontal Layout", "Horizontal Tree Layout", "Vertical Layout", "Radial Layout", "Directed Graph Layout", "Composite Layout [Directed Graph + Horizontal Shift]", "Composite Layout [Spring Layout + Horizontal Shift]", "Composite Layout [Radial Layout + Horizontal Shift]", "Composite Layout [Tree Layout + Horizontal Shift]");

    public ZestLayoutDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return "Layout diagram with Zest Layouter";
    }

    public String getName() {
        return "Layout Diagram (Zest)";
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        return pes != null && pes.length == 1 && pes[0] instanceof ContainerShape;
    }

    public void execute(ICustomContext context) {
        Integer type = this.askForLayoutType();
        if (type != null) {
            Map<Connection, Point> selves = this.getSelfConnections();
            LayoutAlgorithm layoutAlgorithm = this.getLayoutAlgorithmn(type);
            if (layoutAlgorithm != null) {
                try {
                    Map<Shape, SimpleNode> map = this.getLayoutEntities();
                    LayoutRelationship[] connections = this.getConnectionEntities(map);
                    LayoutEntity[] entities = map.values().toArray(new LayoutEntity[0]);
                    GraphicsAlgorithm ga = this.getDiagram().getGraphicsAlgorithm();
                    layoutAlgorithm.applyLayout(entities, connections, 0.0, 0.0, (double)ga.getWidth(), (double)ga.getHeight(), false, false);
                    this.updateGraphCoordinates(entities, connections);
                    this.adaptSelfBendPoints(selves);
                }
                catch (InvalidLayoutConfiguration e) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)e);
                }
            }
        }
    }

    private Map<Connection, Point> getSelfConnections() {
        IGaService gaService = Graphiti.getGaService();
        HashMap<Connection, Point> selves = new HashMap<Connection, Point>();
        EList connections = this.getDiagram().getConnections();
        for (Connection connection : connections) {
            AnchorContainer target;
            AnchorContainer source = connection.getStart().getParent();
            if (source != (target = connection.getEnd().getParent())) continue;
            GraphicsAlgorithm p = source.getGraphicsAlgorithm();
            Point start = gaService.createPoint(p.getX(), p.getY());
            selves.put(connection, start);
        }
        return selves;
    }

    private void adaptSelfBendPoints(Map<Connection, Point> selves) {
        for (Map.Entry<Connection, Point> entry : selves.entrySet()) {
            Point p = entry.getValue();
            FreeFormConnection ffcon = (FreeFormConnection)entry.getKey();
            EList pointList = ffcon.getBendpoints();
            AnchorContainer source = ffcon.getStart().getParent();
            GraphicsAlgorithm start = source.getGraphicsAlgorithm();
            int deltaX = start.getX() - p.getX();
            int deltaY = start.getY() - p.getY();
            int i = 0;
            while (i < pointList.size()) {
                Point bendPoint = (Point)pointList.get(i);
                int x = bendPoint.getX();
                bendPoint.setX(x + deltaX);
                int y = bendPoint.getY();
                bendPoint.setY(y + deltaY);
                ++i;
            }
        }
    }

    private void updateGraphCoordinates(LayoutEntity[] entities, LayoutRelationship[] connections) {
        LayoutEntity[] layoutEntityArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutEntity entity = layoutEntityArray[n2];
            SimpleNode node = (SimpleNode)entity;
            Shape shape = (Shape)node.getRealObject();
            Double x = node.getX();
            Double y = node.getY();
            shape.getGraphicsAlgorithm().setX(x.intValue());
            shape.getGraphicsAlgorithm().setY(y.intValue());
            Double width = node.getWidth();
            Double height = node.getHeight();
            shape.getGraphicsAlgorithm().setWidth(width.intValue());
            shape.getGraphicsAlgorithm().setHeight(height.intValue());
            ++n2;
        }
        IGaService gaService = Graphiti.getGaService();
        LayoutRelationship[] layoutRelationshipArray = connections;
        int n3 = connections.length;
        n = 0;
        while (n < n3) {
            LayoutBendPoint[] bendPoints;
            LayoutRelationship relationship = layoutRelationshipArray[n];
            SimpleRelationship rel = (SimpleRelationship)relationship;
            FreeFormConnection connection = (FreeFormConnection)rel.getGraphData();
            connection.getBendpoints().clear();
            LayoutBendPoint[] layoutBendPointArray = bendPoints = rel.getBendPoints();
            int n4 = bendPoints.length;
            int n5 = 0;
            while (n5 < n4) {
                LayoutBendPoint bendPoint = layoutBendPointArray[n5];
                Double x = bendPoint.getX();
                Double y = bendPoint.getY();
                Point p = gaService.createPoint(x.intValue(), y.intValue());
                connection.getBendpoints().add((Object)p);
                ++n5;
            }
            ++n;
        }
    }

    private Map<Shape, SimpleNode> getLayoutEntities() {
        HashMap<Shape, SimpleNode> map = new HashMap<Shape, SimpleNode>();
        EList children = this.getDiagram().getChildren();
        for (Shape shape : children) {
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            SimpleNode entity = new SimpleNode((Object)shape, (double)ga.getX(), (double)ga.getY(), (double)ga.getWidth(), (double)ga.getHeight());
            map.put(shape, entity);
        }
        return map;
    }

    private LayoutRelationship[] getConnectionEntities(Map<Shape, SimpleNode> map) {
        ArrayList<SimpleRelationship> liste = new ArrayList<SimpleRelationship>();
        EList connections = this.getDiagram().getConnections();
        for (Connection connection : connections) {
            String label = null;
            EList decorators = connection.getConnectionDecorators();
            for (ConnectionDecorator decorator : decorators) {
                if (!(decorator.getGraphicsAlgorithm() instanceof Text)) continue;
                label = ((Text)decorator.getGraphicsAlgorithm()).getValue();
            }
            Shape source = (Shape)connection.getStart().getParent();
            SimpleNode sourceEntity = map.get(source);
            Shape target = (Shape)connection.getEnd().getParent();
            SimpleNode targetEntity = map.get(target);
            if (source == target) continue;
            SimpleRelationship relationship = new SimpleRelationship((LayoutEntity)sourceEntity, (LayoutEntity)targetEntity, source != target);
            relationship.setGraphData(connection);
            relationship.clearBendPoints();
            relationship.setLabel(label);
            FreeFormConnection ffcon = (FreeFormConnection)connection;
            EList pointList = ffcon.getBendpoints();
            ArrayList<BendPoint> bendPoints = new ArrayList<BendPoint>();
            int i = 0;
            while (i < pointList.size()) {
                Point point = (Point)pointList.get(i);
                boolean isControlPoint = i != 0 && i != pointList.size() - 1;
                BendPoint bendPoint = new BendPoint((double)point.getX(), (double)point.getY(), isControlPoint);
                bendPoints.add(bendPoint);
                ++i;
            }
            relationship.setBendPoints(bendPoints.toArray(new LayoutBendPoint[0]));
            liste.add(relationship);
            if (sourceEntity != null) {
                sourceEntity.addRelationship((org.eclipse.zest.layouts.exampleStructures.SimpleRelationship)relationship);
            }
            if (targetEntity == null) continue;
            targetEntity.addRelationship((org.eclipse.zest.layouts.exampleStructures.SimpleRelationship)relationship);
        }
        return liste.toArray(new LayoutRelationship[0]);
    }

    private Integer askForLayoutType() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ZestLayoutAlgorithmnChoiceDialog dialog = new ZestLayoutAlgorithmnChoiceDialog(shell);
        return dialog.open();
    }

    private LayoutAlgorithm getLayoutAlgorithmn(int current) {
        SpringLayoutAlgorithm layout;
        int style = 1;
        switch (current) {
            case 1: {
                layout = new SpringLayoutAlgorithm(style);
                System.out.println("SpringLayoutAlgorithmn");
                break;
            }
            case 2: {
                layout = new TreeLayoutAlgorithm(style);
                System.out.println("TreeLayoutAlgorithm");
                break;
            }
            case 3: {
                layout = new GridLayoutAlgorithm(style);
                System.out.println("GridLayoutAlgorithm");
                break;
            }
            case 4: {
                layout = new HorizontalLayoutAlgorithm(style);
                System.out.println("HorizontalLayoutAlgorithm");
                break;
            }
            case 5: {
                layout = new HorizontalTreeLayoutAlgorithm(style);
                System.out.println("HorizontalTreeLayoutAlgorithm");
                break;
            }
            case 6: {
                layout = new VerticalLayoutAlgorithm(style);
                System.out.println("VerticalLayoutAlgorithm");
                break;
            }
            case 7: {
                layout = new RadialLayoutAlgorithm(style);
                System.out.println("RadialLayoutAlgorithm");
                break;
            }
            case 8: {
                layout = new DirectedGraphLayoutAlgorithm(style);
                System.out.println("DirectedGraphLayoutAlgorithm");
                break;
            }
            case 9: {
                layout = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new DirectedGraphLayoutAlgorithm(style), new HorizontalShift(style)});
                System.out.println("CompositeLayoutAlgorithm [DirectedGraphLayoutAlgorithm+HorizontalShift]");
                break;
            }
            case 10: {
                layout = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new SpringLayoutAlgorithm(style), new HorizontalShift(style)});
                System.out.println("CompositeLayoutAlgorithm [SpringLayoutAlgorithm+HorizontalShift]");
                break;
            }
            case 11: {
                layout = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new RadialLayoutAlgorithm(style), new HorizontalShift(style)});
                System.out.println("CompositeLayoutAlgorithm [RadialLayoutAlgorithm+HorizontalShift]");
                break;
            }
            case 12: {
                layout = new HorizontalShift(style);
                System.out.println("HorizontalShift");
                break;
            }
            default: {
                layout = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new TreeLayoutAlgorithm(style), new HorizontalShift(style)});
                System.out.println("CompositeLayoutAlgorithm [TreeLayoutAlgorithm+HorizontalShift]");
            }
        }
        return layout;
    }

    private class SimpleRelationship
    extends org.eclipse.zest.layouts.exampleStructures.SimpleRelationship {
        private Object graphData;

        public SimpleRelationship(LayoutEntity sourceEntity, LayoutEntity destinationEntity, boolean bidirectional) {
            super(sourceEntity, destinationEntity, bidirectional);
        }

        public Object getGraphData() {
            return this.graphData;
        }

        public void setGraphData(Object o) {
            this.graphData = o;
        }
    }
}

