/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.misc;

import java.util.ArrayList;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.swt.graphics.Rectangle;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class LayoutNodeFeature
extends AbstractLayoutFeature {
    public LayoutNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        Object[] bos = this.getAllBusinessObjectsForPictogramElement(pe);
        return bos != null && bos.length == 1 && bos[0] instanceof AbstractCamelModelElement;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        IGaService gaService = Graphiti.getGaService();
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
        Rectangle maxDim = new Rectangle(containerGa.getX(), containerGa.getY(), containerGa.getWidth(), containerGa.getHeight());
        ArrayList<PictogramElement> containers = new ArrayList<PictogramElement>();
        NodeUtils.getAllContainers(this.getFeatureProvider(), (AbstractCamelModelElement)bo, containers);
        containers.add((PictogramElement)containerShape);
        for (PictogramElement pe : containers) {
            Object peBO = this.getBusinessObjectForPictogramElement(pe);
            if (!(peBO instanceof AbstractCamelModelElement)) continue;
            IDimension dPe = gaService.calculateSize(pe.getGraphicsAlgorithm(), true);
            if (dPe.getWidth() + pe.getGraphicsAlgorithm().getX() > maxDim.width) {
                maxDim.width = dPe.getWidth() + pe.getGraphicsAlgorithm().getX();
            }
            if (dPe.getHeight() + pe.getGraphicsAlgorithm().getY() <= maxDim.height) continue;
            maxDim.height = dPe.getHeight() + pe.getGraphicsAlgorithm().getY();
        }
        GraphicsAlgorithm rectangle = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
        if (containerGa.getHeight() < maxDim.height) {
            containerGa.setHeight(maxDim.height);
        }
        if (rectangle.getHeight() != containerGa.getHeight()) {
            rectangle.setHeight(containerGa.getHeight());
            anythingChanged = true;
        }
        if (containerGa.getWidth() < maxDim.width) {
            containerGa.setWidth(maxDim.width);
            anythingChanged = true;
        }
        int rectangleWidth = containerGa.getWidth();
        if (rectangle.getWidth() != rectangleWidth) {
            rectangle.setWidth(rectangleWidth);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

