/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.misc;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.features.delete.DeleteFigureFeature;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.w3c.dom.Node;

public class MoveNodeFeature
extends DefaultMoveShapeFeature {
    public MoveNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object modelToMoveObject = this.getBusinessObjectForPictogramElement(pe);
        if (modelToMoveObject instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement modelToMove = (AbstractCamelModelElement)modelToMoveObject;
            if (modelToMove instanceof CamelRouteElement) {
                return false;
            }
            Object sourceContainer = this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
            Object targetContainer = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            Eip underlyingMetaModelObject = modelToMove.getUnderlyingMetaModelObject();
            return (this.isMovingToAnotherContainer(modelToMove, sourceContainer, targetContainer) || this.isInsertingOnConnectionNotAdjacent(context, modelToMove, targetContainer) || this.isAppendOrPrepending(context, modelToMove, targetContainer)) && new CreateFigureFeature(this.getFeatureProvider(), this.getName(), this.getDescription(), underlyingMetaModelObject).canCreate((ICreateContext)this.createCreateContext(context));
        }
        return false;
    }

    private boolean isAppendOrPrepending(IMoveShapeContext context, AbstractCamelModelElement modelToMove, Object targetContainer) {
        if (context.getTargetConnection() == null && targetContainer instanceof AbstractCamelModelElement) {
            return (((AbstractCamelModelElement)targetContainer).getInputElement() == null || ((AbstractCamelModelElement)targetContainer).getOutputElement() == null) && this.canContain(((AbstractCamelModelElement)targetContainer).getParent(), modelToMove);
        }
        return false;
    }

    private boolean isInsertingOnConnectionNotAdjacent(IMoveShapeContext context, AbstractCamelModelElement modelToMove, Object targetContainer) {
        Connection targetConnection = context.getTargetConnection();
        if (targetConnection != null) {
            AbstractCamelModelElement sourceOfConnection = NodeUtils.getNode(this.getFeatureProvider(), targetConnection.getStart());
            AbstractCamelModelElement targetOfConnection = NodeUtils.getNode(this.getFeatureProvider(), targetConnection.getEnd());
            return !modelToMove.equals(sourceOfConnection) && !modelToMove.equals(targetOfConnection) && this.canContain(targetContainer, modelToMove);
        }
        return false;
    }

    private boolean isMovingToAnotherContainer(AbstractCamelModelElement modelToMove, Object sourceContainer, Object targetContainer) {
        return this.areDifferentContainers(sourceContainer, targetContainer) && this.canContain(targetContainer, modelToMove);
    }

    private boolean areDifferentContainers(Object sourceContainer, Object targetContainer) {
        return sourceContainer != null && !sourceContainer.equals(targetContainer);
    }

    private boolean canContain(Object targetContainer, AbstractCamelModelElement movableModel) {
        if (targetContainer instanceof AbstractCamelModelElement) {
            return NodeUtils.isValidChild((AbstractCamelModelElement)targetContainer, movableModel);
        }
        return false;
    }

    public void moveShape(IMoveShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        AbstractCamelModelElement modelToMove = (AbstractCamelModelElement)this.getBusinessObjectForPictogramElement(pe);
        String id = modelToMove.getId();
        String description = modelToMove.getDescription();
        Eip underlyingMetaModelObject = modelToMove.getUnderlyingMetaModelObject();
        Node xmlNode = modelToMove.getXmlNode();
        DeleteFigureFeature deleteFigureFeature = new DeleteFigureFeature(this.getFeatureProvider());
        DeleteContext deleteContext = new DeleteContext(pe);
        deleteContext.putProperty((Object)"SKIP_ASKING_DELETE_CONFIRMATION", (Object)"true");
        deleteFigureFeature.delete((IDeleteContext)deleteContext);
        CreateFigureFeature createFigureFeature = new CreateFigureFeature(this.getFeatureProvider(), id, description, underlyingMetaModelObject, xmlNode);
        CreateContext createContext = this.createCreateContext(context);
        createFigureFeature.create((ICreateContext)createContext);
    }

    private CreateContext createCreateContext(IMoveShapeContext context) {
        CreateContext createContext = new CreateContext();
        createContext.setTargetContainer(context.getTargetContainer());
        createContext.setTargetConnection(context.getTargetConnection());
        return createContext;
    }
}

