/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.misc;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class ReconnectNodesFeature
extends DefaultReconnectionFeature {
    public ReconnectNodesFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canReconnect(IReconnectionContext context) {
        return super.canReconnect(context) && this.isReconnectValid(context);
    }

    public void postReconnect(IReconnectionContext context) {
        super.postReconnect(context);
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
            AbstractCamelModelElement target = NodeUtils.getNode(this.getFeatureProvider(), context.getConnection().getEnd());
            AbstractCamelModelElement oldSource = NodeUtils.getNode(this.getFeatureProvider(), context.getOldAnchor());
            AbstractCamelModelElement newSource = NodeUtils.getNode(this.getFeatureProvider(), context.getNewAnchor());
            if (oldSource.equals(target.getInputElement())) {
                target.setInputElement(null);
                oldSource.setOutputElement(null);
            }
            if (oldSource.equals(target.getOutputElement())) {
                target.setOutputElement(null);
                oldSource.setInputElement(null);
            }
            new CamelElementConnection(newSource, target);
        } else {
            AbstractCamelModelElement source = NodeUtils.getNode(this.getFeatureProvider(), context.getConnection().getStart());
            AbstractCamelModelElement oldTarget = NodeUtils.getNode(this.getFeatureProvider(), context.getOldAnchor());
            AbstractCamelModelElement newTarget = NodeUtils.getNode(this.getFeatureProvider(), context.getNewAnchor());
            if (oldTarget.equals(source.getOutputElement())) {
                source.setOutputElement(null);
                oldTarget.setInputElement(null);
            }
            if (oldTarget.equals(source.getInputElement())) {
                source.setInputElement(null);
                oldTarget.setOutputElement(null);
            }
            new CamelElementConnection(source, newTarget);
        }
        DiagramOperations.layoutDiagram((CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer());
    }

    private AbstractCamelModelElement getNode(Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof AbstractCamelModelElement) {
            return (AbstractCamelModelElement)obj;
        }
        return null;
    }

    private boolean isReconnectValid(IReconnectionContext context) {
        if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
            AbstractCamelModelElement newTarget = this.getNode(context.getConnection().getEnd());
            AbstractCamelModelElement source = this.getNode(context.getNewAnchor());
            return ReconnectNodesFeature.canElementsConnect(source, newTarget, context.getReconnectType());
        }
        AbstractCamelModelElement source = this.getNode(context.getConnection().getStart());
        AbstractCamelModelElement newTarget = this.getNode(context.getNewAnchor());
        return ReconnectNodesFeature.canElementsConnect(source, newTarget, context.getReconnectType());
    }

    public static boolean canElementsConnect(AbstractCamelModelElement source, AbstractCamelModelElement target) {
        return ReconnectNodesFeature.canElementsConnect(source, target, ReconnectionContext.RECONNECT_TARGET);
    }

    public static boolean canElementsConnect(AbstractCamelModelElement source, AbstractCamelModelElement target, String reconnectType) {
        if (ReconnectionContext.RECONNECT_SOURCE.equals(reconnectType)) {
            return source != null && target != null && !source.equals(target) && !target.getLastInFlow().equals(source) && source.getParent().equals(target.getParent()) && source.getOutputElement() == null && (source.getInputElement() == null || !source.getInputElement().equals(target)) && !(source instanceof CamelRouteElement) && !(target instanceof CamelRouteElement);
        }
        return source != null && target != null && !source.equals(target) && source.getParent().equals(target.getParent()) && target.getInputElement() == null && !(source instanceof CamelRouteElement) && !(target instanceof CamelRouteElement) && !target.equals(source.getFirstInFlow());
    }
}

