/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.misc;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class UpdateNodeFeature
extends AbstractUpdateFeature {
    private boolean changed = false;

    public UpdateNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof AbstractCamelModelElement;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        String pictogramName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (GraphicsAlgorithm shape : cs.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
                if (!(shape instanceof Text)) continue;
                Text text = (Text)shape;
                pictogramName = text.getValue();
                break;
            }
        }
        String businessName = null;
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement eClass = (AbstractCamelModelElement)bo;
            CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
            if (editor.getModel() != null) {
                AbstractCamelModelElement bo2 = editor.getModel().findNode(eClass.getId());
                if (bo2 != null && !bo2.getXmlNode().isEqualNode(eClass.getXmlNode())) {
                    return Reason.createTrueReason((String)"The Model has been changed. Please update the figure.");
                }
                businessName = eClass.getDisplayText();
            }
        }
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)"Name is out of date");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        this.changed = false;
        String businessName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractCamelModelElement) {
            AbstractCamelModelElement eClass = (AbstractCamelModelElement)bo;
            CamelDesignEditor editor = (CamelDesignEditor)this.getDiagramBehavior().getDiagramContainer();
            AbstractCamelModelElement bo2 = editor.getModel().findNode(eClass.getId());
            if (bo2 != null && !bo2.getXmlNode().isEqualNode(eClass.getXmlNode())) {
                this.link(pictogramElement, bo2);
                this.changed = true;
            }
            businessName = eClass.getDisplayText();
        }
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (GraphicsAlgorithm shape : cs.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
                if (shape instanceof Text) {
                    Text text = (Text)shape;
                    text.setValue(businessName);
                    this.changed = true;
                    continue;
                }
                if (!(shape instanceof Image)) continue;
                AbstractCamelModelElement addedClass = (AbstractCamelModelElement)bo;
                String iconKey = ImageProvider.getKeyForDiagramIcon(addedClass.isEndpointElement(), addedClass.getIconName());
                ((Image)shape).setId(iconKey);
                this.changed = true;
            }
        }
        return this.changed;
    }

    public boolean hasDoneChanges() {
        return this.changed;
    }
}

