/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.AbstractBeanInputDialog;
import org.fusesource.ide.camel.editor.internal.UIMessages;

public class ArgumentInputDialog
extends AbstractBeanInputDialog {
    private Text argumentValueText;
    private String argumentType = null;
    private String argumentValue = null;

    public ArgumentInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(UIMessages.argumentInputDialogDialogTitle);
        this.setMessage(UIMessages.argumentInputDialogDialogMessage);
        this.getShell().setText(UIMessages.argumentInputDialogDialogWindowTitle);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        Text argumentTypeText = this.createLabelAndText(area, UIMessages.argumentInputDialogTypeFieldLabel);
        if (this.argumentType != null && !this.argumentType.trim().isEmpty()) {
            argumentTypeText.setText(this.argumentType);
        }
        argumentTypeText.addModifyListener(input -> {
            this.argumentType = argumentTypeText.getText().trim();
            this.getButton(0).setEnabled(this.validate());
        });
        this.argumentValueText = this.createLabelAndText(area, UIMessages.argumentInputDialogValueFieldLabel);
        if (this.argumentValue != null && !this.argumentValue.trim().isEmpty()) {
            this.argumentValueText.setText(this.argumentValue);
        }
        this.argumentValueText.addModifyListener(input -> {
            this.argumentValue = this.argumentValueText.getText().trim();
            this.getButton(0).setEnabled(this.validate());
        });
        return area;
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        if (this.argumentValueText.getText().trim().isEmpty()) {
            this.setErrorMessage(UIMessages.argumentInputDialogErrorMessage);
        }
        return this.getErrorMessage() == null;
    }

    public String getArgumentType() {
        return this.argumentType;
    }

    public String getArgumentValue() {
        return this.argumentValue;
    }

    public void setArgumentType(String type) {
        this.argumentType = type;
    }

    public void setArgumentValue(String value) {
        this.argumentValue = value;
    }
}

