/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.ArgumentInputDialog;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.ArgumentStyleBaseTableControl;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArgumentStyleChildTableControl
extends ArgumentStyleBaseTableControl {
    private AbstractCamelModelElement inputElement;
    private List<AbstractCamelModelElement> argumentList = new ArrayList<AbstractCamelModelElement>();

    public ArgumentStyleChildTableControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public ArgumentStyleChildTableControl(Composite parent, int style, boolean isReadOnly) {
        super(parent, style, isReadOnly);
        this.propertyTreeTable.setInput(this.argumentList);
        this.updateArgumentTypeButtons();
    }

    @Override
    protected void removeArgumentFromList() {
        if (!this.getStructuredSelection().isEmpty()) {
            AbstractCamelModelElement selectedProperty = (AbstractCamelModelElement)this.getStructuredSelection().getFirstElement();
            this.argumentList.remove(selectedProperty);
        }
    }

    @Override
    protected void addArgumentTypeToList() {
        ArgumentInputDialog dialog = new ArgumentInputDialog(Display.getCurrent().getActiveShell());
        int rtnValue = dialog.open();
        if (rtnValue == 0) {
            String type = dialog.getArgumentType();
            String value = dialog.getArgumentValue();
            this.addBeanArgument(type, value);
        }
    }

    @Override
    protected void editArgumentType() {
        if (!this.getStructuredSelection().isEmpty()) {
            int rtnValue;
            AbstractCamelModelElement selectedProperty = (AbstractCamelModelElement)this.getStructuredSelection().getFirstElement();
            ArgumentInputDialog dialog = new ArgumentInputDialog(Display.getCurrent().getActiveShell());
            Element xmlElement = (Element)selectedProperty.getXmlNode();
            if (xmlElement.getAttribute("type") != null) {
                dialog.setArgumentType(xmlElement.getAttribute("type"));
            }
            if (xmlElement.getAttribute("value") != null) {
                dialog.setArgumentValue(xmlElement.getAttribute("value"));
            }
            if ((rtnValue = dialog.open()) == 0) {
                String type = dialog.getArgumentType();
                String value = dialog.getArgumentValue();
                this.beanConfigUtil.editBeanArgument(xmlElement, type, value);
            }
        }
    }

    public void setInput(AbstractCamelModelElement input) {
        this.inputElement = input;
    }

    @Override
    protected void addBeanArgument(String type, String value) {
        CamelFile camelFile = this.inputElement.getCamelFile();
        Element propertyNode = this.beanConfigUtil.createBeanArgument(camelFile, type, value);
        CamelBasicModelElement newProperty = new CamelBasicModelElement(null, (Node)propertyNode);
        this.argumentList.add((AbstractCamelModelElement)newProperty);
    }

    public List<AbstractCamelModelElement> getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List<AbstractCamelModelElement> list) {
        this.argumentList = list;
    }

    @Override
    protected ITableLabelProvider getTableLabelProvider() {
        return new ArgumentTypeTreeLabelProvider();
    }

    @Override
    protected ITreeContentProvider getTableContentProvider() {
        return new ArgumentTypeTreeContentProvider();
    }

    private class ArgumentTypeTreeContentProvider
    implements ITreeContentProvider {
        private List<AbstractCamelModelElement> properties;

        private ArgumentTypeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.properties = (List)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return this.properties.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractCamelModelElement) {
                AbstractCamelModelElement parent = (AbstractCamelModelElement)parentElement;
                return new Object[]{parent.getChildElements()};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractCamelModelElement) {
                return ((AbstractCamelModelElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return !((List)element).isEmpty();
            }
            return false;
        }
    }

    private class ArgumentTypeTreeLabelProvider
    implements ITableLabelProvider {
        private ArgumentTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return element instanceof AbstractCamelModelElement && (property.equalsIgnoreCase("type") || property.equalsIgnoreCase("value"));
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AbstractCamelModelElement && columnIndex == 0) {
                Element xmlElement = (Element)((AbstractCamelModelElement)element).getXmlNode();
                return xmlElement.getAttribute("type");
            }
            if (element instanceof AbstractCamelModelElement && columnIndex == 1) {
                Element xmlElement = (Element)((AbstractCamelModelElement)element).getXmlNode();
                return xmlElement.getAttribute("value");
            }
            return null;
        }
    }
}

